/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;

@JsonDeserialize(builder=Builder.class)
public class AuditLogImp
implements AuditLog {
    protected UUID auditedEntityId;
    protected ObjectType auditedObjectType;
    protected ChangeType changeType;
    protected String comment;
    protected DateTime createdDate;
    protected UUID id;
    protected String reasonCode;
    protected DateTime updatedDate;
    protected String userName;
    protected String userToken;

    public AuditLogImp(AuditLogImp that) {
        this.auditedEntityId = that.auditedEntityId;
        this.auditedObjectType = that.auditedObjectType;
        this.changeType = that.changeType;
        this.comment = that.comment;
        this.createdDate = that.createdDate;
        this.id = that.id;
        this.reasonCode = that.reasonCode;
        this.updatedDate = that.updatedDate;
        this.userName = that.userName;
        this.userToken = that.userToken;
    }

    protected AuditLogImp(Builder<?> builder) {
        this.auditedEntityId = builder.auditedEntityId;
        this.auditedObjectType = builder.auditedObjectType;
        this.changeType = builder.changeType;
        this.comment = builder.comment;
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.reasonCode = builder.reasonCode;
        this.updatedDate = builder.updatedDate;
        this.userName = builder.userName;
        this.userToken = builder.userToken;
    }

    protected AuditLogImp() {
    }

    public UUID getAuditedEntityId() {
        return this.auditedEntityId;
    }

    public ObjectType getAuditedObjectType() {
        return this.auditedObjectType;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public String getComment() {
        return this.comment;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public UUID getId() {
        return this.id;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogImp that = (AuditLogImp)o;
        if (!Objects.equals(this.auditedEntityId, that.auditedEntityId)) {
            return false;
        }
        if (!Objects.equals(this.auditedObjectType, that.auditedObjectType)) {
            return false;
        }
        if (!Objects.equals(this.changeType, that.changeType)) {
            return false;
        }
        if (!Objects.equals(this.comment, that.comment)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.reasonCode, that.reasonCode)) {
            return false;
        }
        if (this.updatedDate != null ? 0 != this.updatedDate.compareTo((ReadableInstant)that.updatedDate) : that.updatedDate != null) {
            return false;
        }
        if (!Objects.equals(this.userName, that.userName)) {
            return false;
        }
        return Objects.equals(this.userToken, that.userToken);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.auditedEntityId);
        result = 31 * result + Objects.hashCode(this.auditedObjectType);
        result = 31 * result + Objects.hashCode(this.changeType);
        result = 31 * result + Objects.hashCode(this.comment);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.reasonCode);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        result = 31 * result + Objects.hashCode(this.userName);
        result = 31 * result + Objects.hashCode(this.userToken);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("auditedEntityId=").append(this.auditedEntityId);
        sb.append(", ");
        sb.append("auditedObjectType=").append(this.auditedObjectType);
        sb.append(", ");
        sb.append("changeType=").append(this.changeType);
        sb.append(", ");
        sb.append("comment=");
        if (this.comment == null) {
            sb.append(this.comment);
        } else {
            sb.append("'").append(this.comment).append("'");
        }
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("reasonCode=");
        if (this.reasonCode == null) {
            sb.append(this.reasonCode);
        } else {
            sb.append("'").append(this.reasonCode).append("'");
        }
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append(", ");
        sb.append("userName=");
        if (this.userName == null) {
            sb.append(this.userName);
        } else {
            sb.append("'").append(this.userName).append("'");
        }
        sb.append(", ");
        sb.append("userToken=");
        if (this.userToken == null) {
            sb.append(this.userToken);
        } else {
            sb.append("'").append(this.userToken).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID auditedEntityId;
        protected ObjectType auditedObjectType;
        protected ChangeType changeType;
        protected String comment;
        protected DateTime createdDate;
        protected UUID id;
        protected String reasonCode;
        protected DateTime updatedDate;
        protected String userName;
        protected String userToken;

        public Builder() {
        }

        public Builder(Builder that) {
            this.auditedEntityId = that.auditedEntityId;
            this.auditedObjectType = that.auditedObjectType;
            this.changeType = that.changeType;
            this.comment = that.comment;
            this.createdDate = that.createdDate;
            this.id = that.id;
            this.reasonCode = that.reasonCode;
            this.updatedDate = that.updatedDate;
            this.userName = that.userName;
            this.userToken = that.userToken;
        }

        public T withAuditedEntityId(UUID auditedEntityId) {
            this.auditedEntityId = auditedEntityId;
            return (T)this;
        }

        public T withAuditedObjectType(ObjectType auditedObjectType) {
            this.auditedObjectType = auditedObjectType;
            return (T)this;
        }

        public T withChangeType(ChangeType changeType) {
            this.changeType = changeType;
            return (T)this;
        }

        public T withComment(String comment) {
            this.comment = comment;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T withUserName(String userName) {
            this.userName = userName;
            return (T)this;
        }

        public T withUserToken(String userToken) {
            this.userToken = userToken;
            return (T)this;
        }

        public T source(AuditLog that) {
            this.auditedEntityId = that.getAuditedEntityId();
            this.auditedObjectType = that.getAuditedObjectType();
            this.changeType = that.getChangeType();
            this.comment = that.getComment();
            this.createdDate = that.getCreatedDate();
            this.id = that.getId();
            this.reasonCode = that.getReasonCode();
            this.updatedDate = that.getUpdatedDate();
            this.userName = that.getUserName();
            this.userToken = that.getUserToken();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public AuditLogImp build() {
            return new AuditLogImp(this.validate());
        }
    }
}

