/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.util.api.ColumnInfo;

@JsonDeserialize(builder=Builder.class)
public class ColumnInfoImp
implements ColumnInfo {
    protected String columnName;
    protected String dataType;
    protected String tableName;

    public ColumnInfoImp(ColumnInfoImp that) {
        this.columnName = that.columnName;
        this.dataType = that.dataType;
        this.tableName = that.tableName;
    }

    protected ColumnInfoImp(Builder<?> builder) {
        this.columnName = builder.columnName;
        this.dataType = builder.dataType;
        this.tableName = builder.tableName;
    }

    protected ColumnInfoImp() {
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfoImp that = (ColumnInfoImp)o;
        if (!Objects.equals(this.columnName, that.columnName)) {
            return false;
        }
        if (!Objects.equals(this.dataType, that.dataType)) {
            return false;
        }
        return Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.columnName);
        result = 31 * result + Objects.hashCode(this.dataType);
        result = 31 * result + Objects.hashCode(this.tableName);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("columnName=");
        if (this.columnName == null) {
            sb.append(this.columnName);
        } else {
            sb.append("'").append(this.columnName).append("'");
        }
        sb.append(", ");
        sb.append("dataType=");
        if (this.dataType == null) {
            sb.append(this.dataType);
        } else {
            sb.append("'").append(this.dataType).append("'");
        }
        sb.append(", ");
        sb.append("tableName=");
        if (this.tableName == null) {
            sb.append(this.tableName);
        } else {
            sb.append("'").append(this.tableName).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String columnName;
        protected String dataType;
        protected String tableName;

        public Builder() {
        }

        public Builder(Builder that) {
            this.columnName = that.columnName;
            this.dataType = that.dataType;
            this.tableName = that.tableName;
        }

        public T withColumnName(String columnName) {
            this.columnName = columnName;
            return (T)this;
        }

        public T withDataType(String dataType) {
            this.dataType = dataType;
            return (T)this;
        }

        public T withTableName(String tableName) {
            this.tableName = tableName;
            return (T)this;
        }

        public T source(ColumnInfo that) {
            this.columnName = that.getColumnName();
            this.dataType = that.getDataType();
            this.tableName = that.getTableName();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public ColumnInfoImp build() {
            return new ColumnInfoImp(this.validate());
        }
    }
}

