/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.usage.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import org.killbill.billing.usage.api.RolledUpUnit;

@JsonDeserialize(builder=Builder.class)
public class RolledUpUnitImp
implements RolledUpUnit {
    protected BigDecimal amount;
    protected String unitType;

    public RolledUpUnitImp(RolledUpUnitImp that) {
        this.amount = that.amount;
        this.unitType = that.unitType;
    }

    protected RolledUpUnitImp(Builder<?> builder) {
        this.amount = builder.amount;
        this.unitType = builder.unitType;
    }

    protected RolledUpUnitImp() {
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolledUpUnitImp that = (RolledUpUnitImp)o;
        if (!Objects.equals(this.amount, that.amount)) {
            return false;
        }
        return Objects.equals(this.unitType, that.unitType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.amount);
        result = 31 * result + Objects.hashCode(this.unitType);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("amount=").append(this.amount);
        sb.append(", ");
        sb.append("unitType=");
        if (this.unitType == null) {
            sb.append(this.unitType);
        } else {
            sb.append("'").append(this.unitType).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BigDecimal amount;
        protected String unitType;

        public Builder() {
        }

        public Builder(Builder that) {
            this.amount = that.amount;
            this.unitType = that.unitType;
        }

        public T withAmount(BigDecimal amount) {
            this.amount = amount;
            return (T)this;
        }

        public T withUnitType(String unitType) {
            this.unitType = unitType;
            return (T)this;
        }

        public T source(RolledUpUnit that) {
            this.amount = that.getAmount();
            this.unitType = that.getUnitType();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public RolledUpUnitImp build() {
            return new RolledUpUnitImp(this.validate());
        }
    }
}

