/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.usage.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.usage.api.RawUsageRecord;

@JsonDeserialize(builder=Builder.class)
public class RawUsageRecordImp
implements RawUsageRecord {
    protected BigDecimal amount;
    protected DateTime date;
    protected UUID subscriptionId;
    protected String trackingId;
    protected String unitType;

    public RawUsageRecordImp(RawUsageRecordImp that) {
        this.amount = that.amount;
        this.date = that.date;
        this.subscriptionId = that.subscriptionId;
        this.trackingId = that.trackingId;
        this.unitType = that.unitType;
    }

    protected RawUsageRecordImp(Builder<?> builder) {
        this.amount = builder.amount;
        this.date = builder.date;
        this.subscriptionId = builder.subscriptionId;
        this.trackingId = builder.trackingId;
        this.unitType = builder.unitType;
    }

    protected RawUsageRecordImp() {
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public DateTime getDate() {
        return this.date;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawUsageRecordImp that = (RawUsageRecordImp)o;
        if (!Objects.equals(this.amount, that.amount)) {
            return false;
        }
        if (this.date != null ? 0 != this.date.compareTo((ReadableInstant)that.date) : that.date != null) {
            return false;
        }
        if (!Objects.equals(this.subscriptionId, that.subscriptionId)) {
            return false;
        }
        if (!Objects.equals(this.trackingId, that.trackingId)) {
            return false;
        }
        return Objects.equals(this.unitType, that.unitType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.amount);
        result = 31 * result + Objects.hashCode(this.date);
        result = 31 * result + Objects.hashCode(this.subscriptionId);
        result = 31 * result + Objects.hashCode(this.trackingId);
        result = 31 * result + Objects.hashCode(this.unitType);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("amount=").append(this.amount);
        sb.append(", ");
        sb.append("date=").append(this.date);
        sb.append(", ");
        sb.append("subscriptionId=").append(this.subscriptionId);
        sb.append(", ");
        sb.append("trackingId=");
        if (this.trackingId == null) {
            sb.append(this.trackingId);
        } else {
            sb.append("'").append(this.trackingId).append("'");
        }
        sb.append(", ");
        sb.append("unitType=");
        if (this.unitType == null) {
            sb.append(this.unitType);
        } else {
            sb.append("'").append(this.unitType).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BigDecimal amount;
        protected DateTime date;
        protected UUID subscriptionId;
        protected String trackingId;
        protected String unitType;

        public Builder() {
        }

        public Builder(Builder that) {
            this.amount = that.amount;
            this.date = that.date;
            this.subscriptionId = that.subscriptionId;
            this.trackingId = that.trackingId;
            this.unitType = that.unitType;
        }

        public T withAmount(BigDecimal amount) {
            this.amount = amount;
            return (T)this;
        }

        public T withDate(DateTime date) {
            this.date = date;
            return (T)this;
        }

        public T withSubscriptionId(UUID subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (T)this;
        }

        public T withTrackingId(String trackingId) {
            this.trackingId = trackingId;
            return (T)this;
        }

        public T withUnitType(String unitType) {
            this.unitType = unitType;
            return (T)this;
        }

        public T source(RawUsageRecord that) {
            this.amount = that.getAmount();
            this.date = that.getDate();
            this.subscriptionId = that.getSubscriptionId();
            this.trackingId = that.getTrackingId();
            this.unitType = that.getUnitType();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public RawUsageRecordImp build() {
            return new RawUsageRecordImp(this.validate());
        }
    }
}

