/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.tenant.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.tenant.api.TenantKV;

@JsonDeserialize(builder=Builder.class)
public class TenantKVImp
implements TenantKV {
    protected DateTime createdDate;
    protected UUID id;
    protected String key;
    protected DateTime updatedDate;
    protected String value;

    public TenantKVImp(TenantKVImp that) {
        this.createdDate = that.createdDate;
        this.id = that.id;
        this.key = that.key;
        this.updatedDate = that.updatedDate;
        this.value = that.value;
    }

    protected TenantKVImp(Builder<?> builder) {
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.key = builder.key;
        this.updatedDate = builder.updatedDate;
        this.value = builder.value;
    }

    protected TenantKVImp() {
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public UUID getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantKVImp that = (TenantKVImp)o;
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (this.updatedDate != null ? 0 != this.updatedDate.compareTo((ReadableInstant)that.updatedDate) : that.updatedDate != null) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.key);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("key=");
        if (this.key == null) {
            sb.append(this.key);
        } else {
            sb.append("'").append(this.key).append("'");
        }
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append(", ");
        sb.append("value=");
        if (this.value == null) {
            sb.append(this.value);
        } else {
            sb.append("'").append(this.value).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected DateTime createdDate;
        protected UUID id;
        protected String key;
        protected DateTime updatedDate;
        protected String value;

        public Builder() {
        }

        public Builder(Builder that) {
            this.createdDate = that.createdDate;
            this.id = that.id;
            this.key = that.key;
            this.updatedDate = that.updatedDate;
            this.value = that.value;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withKey(String key) {
            this.key = key;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T withValue(String value) {
            this.value = value;
            return (T)this;
        }

        public T source(TenantKV that) {
            this.createdDate = that.getCreatedDate();
            this.id = that.getId();
            this.key = that.getKey();
            this.updatedDate = that.getUpdatedDate();
            this.value = that.getValue();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TenantKVImp build() {
            return new TenantKVImp(this.validate());
        }
    }
}

