/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.tenant.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.tenant.api.Tenant;

@JsonDeserialize(builder=Builder.class)
public class TenantImp
implements Tenant {
    protected String apiKey;
    protected String apiSecret;
    protected DateTime createdDate;
    protected String externalKey;
    protected UUID id;
    protected DateTime updatedDate;

    public TenantImp(TenantImp that) {
        this.apiKey = that.apiKey;
        this.apiSecret = that.apiSecret;
        this.createdDate = that.createdDate;
        this.externalKey = that.externalKey;
        this.id = that.id;
        this.updatedDate = that.updatedDate;
    }

    protected TenantImp(Builder<?> builder) {
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.createdDate = builder.createdDate;
        this.externalKey = builder.externalKey;
        this.id = builder.id;
        this.updatedDate = builder.updatedDate;
    }

    protected TenantImp() {
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantImp that = (TenantImp)o;
        if (!Objects.equals(this.apiKey, that.apiKey)) {
            return false;
        }
        if (!Objects.equals(this.apiSecret, that.apiSecret)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.externalKey, that.externalKey)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo((ReadableInstant)that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.apiKey);
        result = 31 * result + Objects.hashCode(this.apiSecret);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.externalKey);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("apiKey=");
        if (this.apiKey == null) {
            sb.append(this.apiKey);
        } else {
            sb.append("'").append(this.apiKey).append("'");
        }
        sb.append(", ");
        sb.append("apiSecret=");
        if (this.apiSecret == null) {
            sb.append(this.apiSecret);
        } else {
            sb.append("'").append(this.apiSecret).append("'");
        }
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("externalKey=");
        if (this.externalKey == null) {
            sb.append(this.externalKey);
        } else {
            sb.append("'").append(this.externalKey).append("'");
        }
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String apiKey;
        protected String apiSecret;
        protected DateTime createdDate;
        protected String externalKey;
        protected UUID id;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.apiKey = that.apiKey;
            this.apiSecret = that.apiSecret;
            this.createdDate = that.createdDate;
            this.externalKey = that.externalKey;
            this.id = that.id;
            this.updatedDate = that.updatedDate;
        }

        public T withApiKey(String apiKey) {
            this.apiKey = apiKey;
            return (T)this;
        }

        public T withApiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withExternalKey(String externalKey) {
            this.externalKey = externalKey;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(Tenant that) {
            this.apiKey = that.getApiKey();
            this.apiSecret = that.getApiSecret();
            this.createdDate = that.getCreatedDate();
            this.externalKey = that.getExternalKey();
            this.id = that.getId();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TenantImp build() {
            return new TenantImp(this.validate());
        }
    }
}

