/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.tenant.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.tenant.api.TenantData;

@JsonDeserialize(builder=Builder.class)
public class TenantDataImp
implements TenantData {
    protected String apiKey;
    protected String apiSecret;
    protected String externalKey;

    public TenantDataImp(TenantDataImp that) {
        this.apiKey = that.apiKey;
        this.apiSecret = that.apiSecret;
        this.externalKey = that.externalKey;
    }

    protected TenantDataImp(Builder<?> builder) {
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.externalKey = builder.externalKey;
    }

    protected TenantDataImp() {
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantDataImp that = (TenantDataImp)o;
        if (!Objects.equals(this.apiKey, that.apiKey)) {
            return false;
        }
        if (!Objects.equals(this.apiSecret, that.apiSecret)) {
            return false;
        }
        return Objects.equals(this.externalKey, that.externalKey);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.apiKey);
        result = 31 * result + Objects.hashCode(this.apiSecret);
        result = 31 * result + Objects.hashCode(this.externalKey);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("apiKey=");
        if (this.apiKey == null) {
            sb.append(this.apiKey);
        } else {
            sb.append("'").append(this.apiKey).append("'");
        }
        sb.append(", ");
        sb.append("apiSecret=");
        if (this.apiSecret == null) {
            sb.append(this.apiSecret);
        } else {
            sb.append("'").append(this.apiSecret).append("'");
        }
        sb.append(", ");
        sb.append("externalKey=");
        if (this.externalKey == null) {
            sb.append(this.externalKey);
        } else {
            sb.append("'").append(this.externalKey).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String apiKey;
        protected String apiSecret;
        protected String externalKey;

        public Builder() {
        }

        public Builder(Builder that) {
            this.apiKey = that.apiKey;
            this.apiSecret = that.apiSecret;
            this.externalKey = that.externalKey;
        }

        public T withApiKey(String apiKey) {
            this.apiKey = apiKey;
            return (T)this;
        }

        public T withApiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return (T)this;
        }

        public T withExternalKey(String externalKey) {
            this.externalKey = externalKey;
            return (T)this;
        }

        public T source(TenantData that) {
            this.apiKey = that.getApiKey();
            this.apiSecret = that.getApiSecret();
            this.externalKey = that.getExternalKey();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TenantDataImp build() {
            return new TenantDataImp(this.validate());
        }
    }
}

