/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.util.http;

import java.util.Map;
import org.killbill.billing.plugin.util.http.UTF8UrlDecoder;
import org.killbill.billing.plugin.util.http.UTF8UrlEncoder;
import org.killbill.commons.utils.Strings;

public enum QueryComputer {
    URL_ENCODING_ENABLED_QUERY_COMPUTER{

        private void encodeAndAppendQueryParam(StringBuilder sb, CharSequence name, CharSequence value) {
            UTF8UrlEncoder.appendEncoded(sb, name);
            if (value != null) {
                sb.append('=');
                UTF8UrlEncoder.appendEncoded(sb, value);
            }
            sb.append('&');
        }

        private void encodeAndAppendQueryParams(StringBuilder sb, Map<String, String> queryParams) {
            for (Map.Entry<String, String> param : queryParams.entrySet()) {
                this.encodeAndAppendQueryParam(sb, param.getKey(), param.getValue());
            }
        }

        private void encodeAndAppendQuery(StringBuilder sb, String query) {
            for (String queryParamString : query.split("&")) {
                CharSequence decodedName;
                int pos = queryParamString.indexOf(61);
                if (pos <= 0) {
                    decodedName = UTF8UrlDecoder.decode(queryParamString);
                    this.encodeAndAppendQueryParam(sb, decodedName, null);
                    continue;
                }
                decodedName = UTF8UrlDecoder.decode(queryParamString, 0, pos);
                int valueStart = pos + 1;
                CharSequence decodedValue = UTF8UrlDecoder.decode(queryParamString, valueStart, queryParamString.length() - valueStart);
                this.encodeAndAppendQueryParam(sb, decodedName, decodedValue);
            }
        }

        @Override
        protected final String withQueryWithParams(String query, Map<String, String> queryParams) {
            StringBuilder sb = new StringBuilder(query.length() + queryParams.size() * 16);
            this.encodeAndAppendQuery(sb, query);
            this.encodeAndAppendQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected final String withQueryWithoutParams(String query) {
            StringBuilder sb = new StringBuilder(query.length() + 6);
            this.encodeAndAppendQuery(sb, query);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected final String withoutQueryWithParams(Map<String, String> queryParams) {
            StringBuilder sb = new StringBuilder(queryParams.size() * 16);
            this.encodeAndAppendQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    }
    ,
    URL_ENCODING_DISABLED_QUERY_COMPUTER{

        private void appendRawQueryParam(StringBuilder sb, String name, String value) {
            sb.append(name);
            if (value != null) {
                sb.append('=').append(value);
            }
            sb.append('&');
        }

        private void appendRawQueryParams(StringBuilder sb, Map<String, String> queryParams) {
            for (Map.Entry<String, String> param : queryParams.entrySet()) {
                this.appendRawQueryParam(sb, param.getKey(), param.getValue());
            }
        }

        @Override
        protected final String withQueryWithParams(String query, Map<String, String> queryParams) {
            StringBuilder sb = new StringBuilder(query.length() + queryParams.size() * 16);
            sb.append(query);
            this.appendRawQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected final String withQueryWithoutParams(String query) {
            return query;
        }

        @Override
        protected final String withoutQueryWithParams(Map<String, String> queryParams) {
            StringBuilder sb = new StringBuilder(queryParams.size() * 16);
            this.appendRawQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    };


    public static QueryComputer queryComputer(boolean disableUrlEncoding) {
        return disableUrlEncoding ? URL_ENCODING_DISABLED_QUERY_COMPUTER : URL_ENCODING_ENABLED_QUERY_COMPUTER;
    }

    protected abstract String withQueryWithParams(String var1, Map<String, String> var2);

    protected abstract String withQueryWithoutParams(String var1);

    protected abstract String withoutQueryWithParams(Map<String, String> var1);

    private String withQuery(String query, Map<String, String> queryParams) {
        return queryParams != null && !queryParams.isEmpty() ? this.withQueryWithParams(query, queryParams) : this.withQueryWithoutParams(query);
    }

    private String withoutQuery(Map<String, String> queryParams) {
        return queryParams != null && !queryParams.isEmpty() ? this.withoutQueryWithParams(queryParams) : null;
    }

    public final String computeFullQueryString(String query, Map<String, String> queryParams) {
        return !Strings.isNullOrEmpty((String)query) ? this.withQuery(query, queryParams) : this.withoutQuery(queryParams);
    }
}

