/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.util.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import org.killbill.billing.plugin.util.http.InvalidRequest;
import org.killbill.billing.plugin.util.http.ResponseFormat;
import org.killbill.billing.plugin.util.http.SslUtils;
import org.killbill.billing.plugin.util.http.URIUtils;
import org.killbill.billing.plugin.util.http.UTF8UrlEncoder;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.killbill.commons.utils.io.CharStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String APPLICATION_XML = "application/xml";
    protected static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    protected static final String GET = "GET";
    protected static final String POST = "POST";
    protected static final String PUT = "PUT";
    protected static final String DELETE = "DELETE";
    protected static final String HEAD = "HEAD";
    protected static final String OPTIONS = "OPTIONS";
    protected static final String USER_AGENT = "KillBill/1.0";
    protected static final int DEFAULT_HTTP_TIMEOUT_SEC = 70;
    private static final int DEFAULT_HTTP_CONNECT_TIMEOUT_SEC = 5;
    protected final String url;
    protected final java.net.http.HttpClient httpClient;
    protected final ObjectMapper mapper;
    protected final String username;
    protected final String password;
    protected int httpTimeoutSec = 70;

    public HttpClient(String url, String username, String password, String proxyHost, Integer proxyPort, boolean strictSSL) throws GeneralSecurityException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.httpClient = this.httpClientBuilder(strictSSL, 5000, proxyHost, proxyPort).build();
        this.mapper = this.createObjectMapper();
    }

    public HttpClient(String url, String username, String password, String proxyHost, Integer proxyPort, boolean strictSSL, int connectTimeoutMs) throws GeneralSecurityException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.httpClient = this.httpClientBuilder(strictSSL, connectTimeoutMs, proxyHost, proxyPort).build();
        this.mapper = this.createObjectMapper();
    }

    public HttpClient(String url, String username, String password, String proxyHost, Integer proxyPort, boolean strictSSL, int connectTimeoutMs, int requestTimeoutMs) throws GeneralSecurityException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.httpClient = this.httpClientBuilder(strictSSL, connectTimeoutMs, proxyHost, proxyPort).build();
        this.mapper = this.createObjectMapper();
        this.httpTimeoutSec = requestTimeoutMs;
    }

    protected HttpClient.Builder httpClientBuilder(boolean strictSSL, int connectTimeoutMs, @Nullable String proxyHost, @Nullable Integer proxyPort) throws GeneralSecurityException {
        HttpClient.Builder builder = java.net.http.HttpClient.newBuilder().sslContext(SslUtils.getInstance().getSSLContext(!strictSSL)).connectTimeout(Duration.of(connectTimeoutMs, ChronoUnit.MILLIS));
        if (proxyHost != null && proxyPort != null) {
            builder.proxy(ProxySelector.of(new InetSocketAddress(proxyHost, (int)proxyPort)));
        }
        return builder;
    }

    @Override
    public void close() {
    }

    protected ObjectMapper createObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    }

    protected String doCallAndReturnTextResponse(String verb, String uri, String body, Map<String, String> queryParams, Map<String, String> headers) throws InvalidRequest, InterruptedException, IOException, URISyntaxException {
        return this.doCall(verb, uri, body, queryParams, headers, String.class, ResponseFormat.TEXT);
    }

    protected <T> T doCall(String verb, String url, String body, Map<String, String> queryParams, Map<String, String> headers, Class<T> clazz, ResponseFormat format) throws InterruptedException, IOException, URISyntaxException, InvalidRequest {
        HttpRequest.Builder builder = this.getBuilderWithHeaderAndQuery(verb, url, headers, queryParams);
        if (!GET.equals(verb) && !HEAD.equals(verb) && body != null) {
            builder.method(verb, HttpRequest.BodyPublishers.ofString(body));
        }
        return this.executeAndWait(builder, this.httpTimeoutSec, clazz, format);
    }

    protected <T> T executeAndWait(HttpRequest.Builder builder, int timeoutSec, Class<T> clazz, ResponseFormat format) throws IOException, InterruptedException, InvalidRequest {
        builder.timeout(Duration.of(timeoutSec, ChronoUnit.SECONDS));
        HttpResponse<InputStream> response = this.httpClient.send(builder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (response != null && response.statusCode() == 401) {
            throw new InvalidRequest("Unauthorized request", response);
        }
        if (response != null && response.statusCode() >= 400) {
            throw new InvalidRequest("Invalid request", response);
        }
        if (response == null) {
            throw new InvalidRequest("No response");
        }
        return this.deserializeResponse(response, clazz, format);
    }

    protected <T> T deserializeResponse(HttpResponse<InputStream> response, Class<T> clazz, ResponseFormat format) throws IOException {
        if (format == ResponseFormat.RAW) {
            return (T)response.body();
        }
        try (InputStream in = response.body();){
            switch (format) {
                case TEXT: {
                    String string = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
                    return (T)string;
                }
            }
            T t2 = this.mapper.readValue(in, clazz);
            return t2;
        }
    }

    protected HttpRequest.Builder getBuilderWithHeaderAndQuery(String verb, String url, Map<String, String> headers, Map<String, String> queryParams) throws URISyntaxException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.getURI(url, queryParams)).method(verb, HttpRequest.BodyPublishers.noBody());
        builder.header("User-Agent", USER_AGENT);
        if (this.username != null && this.password != null) {
            builder.header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8)));
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.headers(entry.getKey(), entry.getValue());
        }
        return builder;
    }

    @VisibleForTesting
    URI getURI(String url, Map<String, String> queryParams) throws URISyntaxException {
        if (url == null) {
            throw new URISyntaxException("(null)", "HttpClient URL misconfigured");
        }
        URI u = new URI(url);
        if (!u.isAbsolute()) {
            u = new URI(String.format("%s%s", this.url, url));
        }
        if (queryParams.isEmpty()) {
            return u;
        }
        StringBuilder sb = new StringBuilder(u.getQuery() == null ? "" : u.getQuery());
        queryParams.keySet().forEach(name -> {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(UTF8UrlEncoder.encode(name));
            sb.append('=');
            sb.append(UTF8UrlEncoder.encode((CharSequence)queryParams.get(name)));
        });
        String query = sb.toString();
        return new URI(URIUtils.buildURI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getAuthority(), u.getRawPath(), query, u.getFragment()));
    }
}

