/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.oone;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.formatters.InvoiceFormatter;
import org.killbill.billing.invoice.api.formatters.InvoiceItemFormatter;
import org.killbill.billing.invoice.plugin.api.InvoiceFormatterFactory;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillEventDispatcher;
import org.killbill.billing.plugin.api.PluginTenantContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OoneListener
implements OSGIKillbillEventDispatcher.OSGIKillbillEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(OoneListener.class);
    private final OSGIKillbillAPI osgiKillbillAPI;
    private final ServiceTracker<InvoiceFormatterFactory, InvoiceFormatterFactory> invoiceFormatterTracker;
    private final Properties configProperties;
    private static final String defaultLocale = "en_US";

    public OoneListener(OSGIKillbillAPI killbillAPI, ServiceTracker<InvoiceFormatterFactory, InvoiceFormatterFactory> invoiceFormatterTracker, Properties configProperties) {
        this.osgiKillbillAPI = killbillAPI;
        this.invoiceFormatterTracker = invoiceFormatterTracker;
        this.configProperties = configProperties;
    }

    public void handleKillbillEvent(ExtBusEvent killbillEvent) {
        logger.info("Received event {} for object id {} of type {}", new Object[]{killbillEvent.getEventType(), killbillEvent.getObjectId(), killbillEvent.getObjectType()});
        PluginTenantContext context = new PluginTenantContext(killbillEvent.getAccountId(), killbillEvent.getTenantId());
        switch (killbillEvent.getEventType()) {
            case ACCOUNT_CREATION: 
            case ACCOUNT_CHANGE: {
                try {
                    Account account = this.osgiKillbillAPI.getAccountUserApi().getAccountById(killbillEvent.getAccountId(), (TenantContext)context);
                    logger.info("Account information: " + String.valueOf(account));
                }
                catch (AccountApiException e) {
                    logger.warn("Unable to find account", (Throwable)e);
                }
                break;
            }
            case INVOICE_CREATION: {
                Account account;
                try {
                    account = this.osgiKillbillAPI.getAccountUserApi().getAccountById(killbillEvent.getAccountId(), (TenantContext)context);
                }
                catch (AccountApiException e) {
                    throw new RuntimeException(e);
                }
                List invoices = this.osgiKillbillAPI.getInvoiceUserApi().getInvoicesByAccount(killbillEvent.getAccountId(), false, false, true, (TenantContext)context);
                logger.info("Invoices in oone-plugin {}: ", (Object)invoices.size());
                String invoiceFormatterPluginName = this.configProperties.getProperty("org.killbill.template.invoiceFormatterFactoryPluginName");
                if (invoiceFormatterPluginName == null || invoiceFormatterPluginName.isEmpty()) {
                    logger.info("Invoice formatter plugin not configured. set the org.killbill.template.invoiceFormatterFactoryPluginName property to configure it");
                    return;
                }
                InvoiceFormatterFactory formatterFactory = this.invoiceFormatterTracker != null ? (InvoiceFormatterFactory)this.invoiceFormatterTracker.getService() : null;
                Invoice invoice = (Invoice)invoices.get(0);
                if (formatterFactory == null) {
                    logger.warn("InvoiceFormatterFactory is not available. Cannot format invoice.");
                    return;
                }
                InvoiceFormatter invoiceFormatter = formatterFactory.createInvoiceFormatter(defaultLocale, null, invoice, Locale.forLanguageTag(account.getLocale()), this.osgiKillbillAPI.getCurrencyConversionApi(), null, null);
                List items = invoiceFormatter.getInvoiceItems();
                logger.info("oone-plugin got items:{}", (Object)items.size());
                for (InvoiceItem item : items) {
                    InvoiceItemFormatter invoiceItemFormatter = (InvoiceItemFormatter)item;
                    String formattedEndDate = invoiceItemFormatter.getFormattedEndDate();
                    logger.info("oone-plugin formattedEndDate:{}", (Object)formattedEndDate);
                }
                break;
            }
        }
    }
}

