/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.oone;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.plugin.api.AdditionalItemsResult;
import org.killbill.billing.invoice.plugin.api.InvoiceContext;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillEventDispatcher;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.plugin.api.invoice.PluginInvoiceItem;
import org.killbill.billing.plugin.api.invoice.PluginInvoicePluginApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

class OoneInvoicePluginApi
extends PluginInvoicePluginApi
implements OSGIKillbillEventDispatcher.OSGIKillbillEventHandler {
    public OoneInvoicePluginApi(OSGIKillbillAPI killbillAPI, OSGIConfigPropertiesService configProperties, Clock clock) {
        super(killbillAPI, configProperties, clock);
    }

    @Override
    public AdditionalItemsResult getAdditionalInvoiceItems(Invoice newInvoice, boolean dryRun, Iterable<PluginProperty> properties, InvoiceContext invoiceContext) {
        UUID accountId = newInvoice.getAccountId();
        Account account = this.getAccount(accountId, (TenantContext)invoiceContext);
        Set<Invoice> allInvoices = this.getAllInvoicesOfAccount(account, newInvoice, (TenantContext)invoiceContext);
        final LinkedList<PluginInvoiceItem> additionalItems = new LinkedList<PluginInvoiceItem>();
        List newInvoiceItems = newInvoice.getInvoiceItems();
        InvoiceItem newInvoiceItem = (InvoiceItem)newInvoiceItems.get(0);
        BigDecimal charge = new BigDecimal("80");
        PluginInvoiceItem taxItem = PluginInvoiceItem.createTaxItem(newInvoiceItem, newInvoiceItem.getInvoiceId(), newInvoice.getInvoiceDate(), null, charge, "Tax Item");
        additionalItems.add(taxItem);
        PluginInvoiceItem externalItem = PluginInvoiceItem.create(newInvoiceItem, newInvoiceItem.getInvoiceId(), newInvoice.getInvoiceDate(), null, charge, "External Item", InvoiceItemType.EXTERNAL_CHARGE);
        additionalItems.add(externalItem);
        for (Invoice invoice : allInvoices) {
            Iterator iterator;
            if (invoice.getId().equals(newInvoice.getId())) continue;
            List invoiceItems = invoice.getInvoiceItems();
            if (this.checkforAdjustmentItem(invoiceItems) || !(iterator = invoiceItems.iterator()).hasNext()) break;
            InvoiceItem item = (InvoiceItem)iterator.next();
            charge = new BigDecimal("-30");
            PluginInvoiceItem adjItem = PluginInvoiceItem.createAdjustmentItem(item, item.getInvoiceId(), newInvoice.getInvoiceDate(), newInvoice.getInvoiceDate(), charge, "Adjustment Item");
            additionalItems.add(adjItem);
            break;
        }
        return new AdditionalItemsResult(){
            final /* synthetic */ OoneInvoicePluginApi this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public List<InvoiceItem> getAdditionalItems() {
                return additionalItems;
            }

            @Override
            public Iterable<PluginProperty> getAdjustedPluginProperties() {
                return null;
            }
        };
    }

    private Set<Invoice> getAllInvoicesOfAccount(Account account, Invoice newInvoice, TenantContext tenantCtx) {
        HashSet<Invoice> invoices = new HashSet<Invoice>();
        invoices.addAll(this.getInvoicesByAccountId(account.getId(), tenantCtx));
        invoices.add(newInvoice);
        return invoices;
    }

    private boolean checkforAdjustmentItem(List<InvoiceItem> invoiceItems) {
        boolean adjustmentItemPresent = false;
        for (InvoiceItem invoiceItem : invoiceItems) {
            if (!invoiceItem.getInvoiceItemType().equals((Object)InvoiceItemType.ITEM_ADJ)) continue;
            adjustmentItemPresent = true;
            break;
        }
        return adjustmentItemPresent;
    }

    protected boolean isTaxItem(InvoiceItem invoiceItem) {
        return InvoiceItemType.TAX.equals((Object)invoiceItem.getInvoiceItemType());
    }

    public void handleKillbillEvent(ExtBusEvent killbillEvent) {
    }
}

