/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.dao.payment;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.joda.time.DateTime;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TransactionalRunnable;
import org.jooq.UpdatableRecord;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.plugin.dao.PluginDao;
import org.killbill.commons.utils.Strings;

public abstract class PluginPaymentDao<RESP_R extends UpdatableRecord<RESP_R>, RESP_T extends Table<RESP_R>, PM_R extends UpdatableRecord<PM_R>, PM_T extends Table<PM_R>>
extends PluginDao {
    protected static final String KB_PAYMENT_ID = "KB_PAYMENT_ID";
    protected static final String KB_PAYMENT_TRANSACTION_ID = "KB_PAYMENT_TRANSACTION_ID";
    protected static final String AMOUNT = "AMOUNT";
    protected static final String CURRENCY = "CURRENCY";
    protected static final String TRANSACTION_TYPE = "TRANSACTION_TYPE";
    protected static final String RECORD_ID = "RECORD_ID";
    protected static final String KB_ACCOUNT_ID = "KB_ACCOUNT_ID";
    protected static final String KB_PAYMENT_METHOD_ID = "KB_PAYMENT_METHOD_ID";
    protected static final String TOKEN = "TOKEN";
    protected static final String CC_FIRST_NAME = "CC_FIRST_NAME";
    protected static final String CC_LAST_NAME = "CC_LAST_NAME";
    protected static final String CC_TYPE = "CC_TYPE";
    protected static final String CC_EXP_MONTH = "CC_EXP_MONTH";
    protected static final String CC_EXP_YEAR = "CC_EXP_YEAR";
    protected static final String CC_NUMBER = "CC_NUMBER";
    protected static final String CC_LAST_4 = "CC_LAST_4";
    protected static final String CC_START_MONTH = "CC_START_MONTH";
    protected static final String CC_START_YEAR = "CC_START_YEAR";
    protected static final String CC_ISSUE_NUMBER = "CC_ISSUE_NUMBER";
    protected static final String CC_VERIFICATION_VALUE = "CC_VERIFICATION_VALUE";
    protected static final String CC_TRACK_DATA = "CC_TRACK_DATA";
    protected static final String ADDRESS1 = "ADDRESS1";
    protected static final String ADDRESS2 = "ADDRESS2";
    protected static final String CITY = "CITY";
    protected static final String STATE = "STATE";
    protected static final String ZIP = "ZIP";
    protected static final String COUNTRY = "COUNTRY";
    protected static final String IS_DEFAULT = "IS_DEFAULT";
    protected static final String IS_DELETED = "IS_DELETED";
    protected static final String ADDITIONAL_DATA = "ADDITIONAL_DATA";
    protected static final String CREATED_DATE = "CREATED_DATE";
    protected static final String UPDATED_DATE = "UPDATED_DATE";
    protected static final String KB_TENANT_ID = "KB_TENANT_ID";
    protected final RESP_T responsesTable;
    protected final PM_T paymentMethodsTable;
    private final String recordIdFieldName;

    public PluginPaymentDao(RESP_T responsesTable, PM_T paymentMethodsTable, DataSource dataSource) throws SQLException {
        this(responsesTable, paymentMethodsTable, dataSource, RECORD_ID);
    }

    public PluginPaymentDao(RESP_T responsesTable, PM_T paymentMethodsTable, DataSource dataSource, SQLDialect dialect) throws SQLException {
        this(responsesTable, paymentMethodsTable, dataSource, dialect, RECORD_ID);
    }

    public PluginPaymentDao(RESP_T responsesTable, PM_T paymentMethodsTable, DataSource dataSource, Settings settings) throws SQLException {
        super(dataSource, settings);
        this.responsesTable = responsesTable;
        this.paymentMethodsTable = paymentMethodsTable;
        this.recordIdFieldName = RECORD_ID;
    }

    public PluginPaymentDao(RESP_T responsesTable, PM_T paymentMethodsTable, DataSource dataSource, SQLDialect dialect, Settings settings) {
        super(dataSource, dialect, settings);
        this.responsesTable = responsesTable;
        this.paymentMethodsTable = paymentMethodsTable;
        this.recordIdFieldName = RECORD_ID;
    }

    public PluginPaymentDao(RESP_T responsesTable, PM_T paymentMethodsTable, DataSource dataSource, SQLDialect dialect, String recordIdFieldName) throws SQLException {
        super(dataSource, dialect);
        this.responsesTable = responsesTable;
        this.paymentMethodsTable = paymentMethodsTable;
        this.recordIdFieldName = recordIdFieldName;
    }

    public PluginPaymentDao(RESP_T responsesTable, PM_T paymentMethodsTable, DataSource dataSource, String recordIdFieldName) throws SQLException {
        super(dataSource);
        this.responsesTable = responsesTable;
        this.paymentMethodsTable = paymentMethodsTable;
        this.recordIdFieldName = recordIdFieldName;
    }

    public void addResponse(final UUID kbAccountId, final UUID kbPaymentId, final UUID kbPaymentTransactionId, final TransactionType transactionType, final BigDecimal amount, final Currency currency, final Map additionalData, final DateTime utcNow, final UUID kbTenantId) throws SQLException {
        this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<Void>(){

            @Override
            public Void withConnection(Connection conn) throws SQLException {
                DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).insertInto(PluginPaymentDao.this.responsesTable, DSL.field(PluginPaymentDao.KB_ACCOUNT_ID), DSL.field(PluginPaymentDao.KB_PAYMENT_ID), DSL.field(PluginPaymentDao.KB_PAYMENT_TRANSACTION_ID), DSL.field(PluginPaymentDao.TRANSACTION_TYPE), DSL.field(PluginPaymentDao.AMOUNT), DSL.field(PluginPaymentDao.CURRENCY), DSL.field(PluginPaymentDao.ADDITIONAL_DATA), DSL.field(PluginPaymentDao.CREATED_DATE), DSL.field(PluginPaymentDao.KB_TENANT_ID)).values(kbAccountId.toString(), kbPaymentId.toString(), kbPaymentTransactionId.toString(), transactionType.toString(), amount, currency == null ? null : currency.name(), PluginPaymentDao.this.asString(additionalData), PluginPaymentDao.toTimestamp(utcNow), kbTenantId.toString()).execute();
                return null;
            }
        });
    }

    public List<RESP_R> getResponses(final UUID kbPaymentId, final UUID kbTenantId) throws SQLException {
        return (List)this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<List<RESP_R>>(){

            @Override
            public List<RESP_R> withConnection(Connection conn) throws SQLException {
                return DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).selectFrom(PluginPaymentDao.this.responsesTable).where(DSL.field(PluginPaymentDao.KB_PAYMENT_ID).equal(kbPaymentId.toString())).and(DSL.field(PluginPaymentDao.KB_TENANT_ID).equal(kbTenantId.toString())).orderBy(DSL.field(PluginPaymentDao.this.recordIdFieldName).asc()).fetch();
            }
        });
    }

    public RESP_R getSuccessfulAuthorizationResponse(final UUID kbPaymentId, final UUID kbTenantId) throws SQLException {
        return (RESP_R)((UpdatableRecord)this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<RESP_R>(){

            @Override
            public RESP_R withConnection(Connection conn) throws SQLException {
                return (UpdatableRecord)DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).selectFrom(PluginPaymentDao.this.responsesTable).where(DSL.field(PluginPaymentDao.KB_PAYMENT_ID).equal(kbPaymentId.toString())).and(DSL.field(PluginPaymentDao.TRANSACTION_TYPE).equal(TransactionType.AUTHORIZE.toString())).and(DSL.field(PluginPaymentDao.KB_TENANT_ID).equal(kbTenantId.toString())).orderBy(DSL.field(PluginPaymentDao.this.recordIdFieldName).desc()).limit(1).fetchOne();
            }
        }));
    }

    public void addPaymentMethod(final UUID kbAccountId, final UUID kbPaymentMethodId, final boolean isDefault, Map<String, String> properties, final DateTime utcNow, final UUID kbTenantId) throws SQLException {
        HashMap<String, String> clonedProperties = new HashMap<String, String>(properties);
        final String token = (String)clonedProperties.remove("token");
        final String ccFirstName = (String)clonedProperties.remove("ccFirstName");
        final String ccLastName = (String)clonedProperties.remove("ccLastName");
        final String ccType = (String)clonedProperties.remove("ccType");
        final String ccExpirationMonth = (String)clonedProperties.remove("ccExpirationMonth");
        final String ccExpirationYear = (String)clonedProperties.remove("ccExpirationYear");
        final String ccNumber = (String)clonedProperties.remove("ccNumber");
        final String ccStartMonth = (String)clonedProperties.remove("ccStartMonth");
        final String ccStartYear = (String)clonedProperties.remove("ccStartYear");
        final String ccIssueNumber = (String)clonedProperties.remove("ccIssueNumber");
        final String ccVerificationValue = (String)clonedProperties.remove("ccVerificationValue");
        final String ccTrackData = (String)clonedProperties.remove("ccTrackData");
        final String address1 = (String)clonedProperties.remove("address1");
        final String address2 = (String)clonedProperties.remove("address2");
        final String city = (String)clonedProperties.remove("city");
        final String state = (String)clonedProperties.remove("state");
        final String zip = (String)clonedProperties.remove("zip");
        final String country = (String)clonedProperties.remove("country");
        final String ccLast4 = Strings.isNullOrEmpty((String)ccNumber) || ccNumber.length() < 4 ? null : ccNumber.substring(ccNumber.length() - 4, ccNumber.length());
        final String additionalData = this.asString(clonedProperties);
        this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<Void>(){

            @Override
            public Void withConnection(Connection conn) throws SQLException {
                DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).insertInto(PluginPaymentDao.this.paymentMethodsTable, new Field[]{DSL.field(PluginPaymentDao.KB_ACCOUNT_ID), DSL.field(PluginPaymentDao.KB_PAYMENT_METHOD_ID), DSL.field(PluginPaymentDao.TOKEN), DSL.field(PluginPaymentDao.CC_FIRST_NAME), DSL.field(PluginPaymentDao.CC_LAST_NAME), DSL.field(PluginPaymentDao.CC_TYPE), DSL.field(PluginPaymentDao.CC_EXP_MONTH), DSL.field(PluginPaymentDao.CC_EXP_YEAR), DSL.field(PluginPaymentDao.CC_NUMBER), DSL.field(PluginPaymentDao.CC_LAST_4), DSL.field(PluginPaymentDao.CC_START_MONTH), DSL.field(PluginPaymentDao.CC_START_YEAR), DSL.field(PluginPaymentDao.CC_ISSUE_NUMBER), DSL.field(PluginPaymentDao.CC_VERIFICATION_VALUE), DSL.field(PluginPaymentDao.CC_TRACK_DATA), DSL.field(PluginPaymentDao.ADDRESS1), DSL.field(PluginPaymentDao.ADDRESS2), DSL.field(PluginPaymentDao.CITY), DSL.field(PluginPaymentDao.STATE), DSL.field(PluginPaymentDao.ZIP), DSL.field(PluginPaymentDao.COUNTRY), DSL.field(PluginPaymentDao.IS_DEFAULT), DSL.field(PluginPaymentDao.IS_DELETED), DSL.field(PluginPaymentDao.ADDITIONAL_DATA), DSL.field(PluginPaymentDao.CREATED_DATE), DSL.field(PluginPaymentDao.UPDATED_DATE), DSL.field(PluginPaymentDao.KB_TENANT_ID)}).values(kbAccountId.toString(), kbPaymentMethodId.toString(), token, ccFirstName, ccLastName, ccType, ccExpirationMonth, ccExpirationYear, ccNumber, ccLast4, ccStartMonth, ccStartYear, ccIssueNumber, ccVerificationValue, ccTrackData, address1, address2, city, state, zip, country, PluginPaymentDao.fromBoolean(isDefault), (byte)48, additionalData, PluginPaymentDao.toTimestamp(utcNow), PluginPaymentDao.toTimestamp(utcNow), kbTenantId.toString()).execute();
                return null;
            }
        });
    }

    public void deletePaymentMethod(final UUID kbPaymentMethodId, final DateTime utcNow, final UUID kbTenantId) throws SQLException {
        this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<Void>(){

            @Override
            public Void withConnection(Connection conn) throws SQLException {
                DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).update(PluginPaymentDao.this.paymentMethodsTable).set(DSL.field(PluginPaymentDao.IS_DELETED), (byte)49).set(DSL.field(PluginPaymentDao.UPDATED_DATE), PluginPaymentDao.toTimestamp(utcNow)).where(DSL.field(PluginPaymentDao.KB_PAYMENT_METHOD_ID).equal(kbPaymentMethodId.toString())).and(DSL.field(PluginPaymentDao.KB_TENANT_ID).equal(kbTenantId.toString())).execute();
                return null;
            }
        });
    }

    public PM_R getPaymentMethod(final UUID kbPaymentMethodId, final UUID kbTenantId) throws SQLException {
        return (PM_R)((UpdatableRecord)this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<PM_R>(){

            @Override
            public PM_R withConnection(Connection conn) throws SQLException {
                return (UpdatableRecord)DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).selectFrom(PluginPaymentDao.this.paymentMethodsTable).where(DSL.field(PluginPaymentDao.KB_PAYMENT_METHOD_ID).equal(kbPaymentMethodId.toString())).and(DSL.field(PluginPaymentDao.IS_DELETED).equal((byte)48)).and(DSL.field(PluginPaymentDao.KB_TENANT_ID).equal(kbTenantId.toString())).orderBy(DSL.field(PluginPaymentDao.this.recordIdFieldName).desc()).fetchOne();
            }
        }));
    }

    public void setDefaultPaymentMethod(final UUID kbAccountId, final UUID kbPaymentMethodId, final DateTime utcNow, final UUID kbTenantId) throws SQLException {
        this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<Void>(){

            @Override
            public Void withConnection(final Connection conn) throws SQLException {
                DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).transaction(new TransactionalRunnable(){

                    @Override
                    public void run(Configuration configuration) throws Exception {
                        DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).update(PluginPaymentDao.this.paymentMethodsTable).set(DSL.field(PluginPaymentDao.IS_DEFAULT), (byte)48).set(DSL.field(PluginPaymentDao.UPDATED_DATE), PluginPaymentDao.toTimestamp(utcNow)).where(DSL.field(PluginPaymentDao.KB_PAYMENT_METHOD_ID).notEqual(kbPaymentMethodId.toString())).and(DSL.field(PluginPaymentDao.KB_ACCOUNT_ID).equal(kbAccountId.toString())).and(DSL.field(PluginPaymentDao.KB_TENANT_ID).equal(kbTenantId.toString())).execute();
                        DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).update(PluginPaymentDao.this.paymentMethodsTable).set(DSL.field(PluginPaymentDao.IS_DEFAULT), (byte)49).set(DSL.field(PluginPaymentDao.UPDATED_DATE), PluginPaymentDao.toTimestamp(utcNow)).where(DSL.field(PluginPaymentDao.KB_PAYMENT_METHOD_ID).equal(kbPaymentMethodId.toString())).and(DSL.field(PluginPaymentDao.KB_TENANT_ID).equal(kbTenantId.toString())).execute();
                    }
                });
                return null;
            }
        });
    }

    public List<PM_R> getPaymentMethods(final UUID kbAccountId, final UUID kbTenantId) throws SQLException {
        return (List)this.execute(this.dataSource.getConnection(), new PluginDao.WithConnectionCallback<List<PM_R>>(){

            @Override
            public List<PM_R> withConnection(Connection conn) throws SQLException {
                return DSL.using(conn, PluginPaymentDao.this.dialect, PluginPaymentDao.this.settings).selectFrom(PluginPaymentDao.this.paymentMethodsTable).where(DSL.field(PluginPaymentDao.KB_ACCOUNT_ID).equal(kbAccountId.toString())).and(DSL.field(PluginPaymentDao.IS_DELETED).equal((byte)48)).and(DSL.field(PluginPaymentDao.KB_TENANT_ID).equal(kbTenantId.toString())).orderBy(DSL.field(PluginPaymentDao.this.recordIdFieldName).asc()).fetch();
            }
        });
    }
}

