/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core.resources.jooby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.util.LinkedList;
import java.util.List;
import org.jooby.json.Jackson;
import org.jooby.servlet.ServerInitializer;
import org.killbill.billing.osgi.libs.killbill.OSGIConfigPropertiesService;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillClock;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillDataSource;
import org.killbill.billing.plugin.core.resources.PluginHealthcheck;
import org.killbill.billing.plugin.core.resources.jooby.PluginApp;

public class PluginAppBuilder {
    public static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private final List<Object> services = new LinkedList<Object>();
    private final List<Class> routeClasses = new LinkedList<Class>();
    private Jackson jackson;
    private Config config;

    public PluginAppBuilder(String pluginName) {
        this.withConfig(ConfigFactory.empty().withValue("application.path", ConfigValueFactory.fromAnyRef(String.format("/plugins/%s/", pluginName))).withValue("server.module", ConfigValueFactory.fromAnyRef(ServerInitializer.ServletModule.class.getName())));
        this.withObjectMapper(DEFAULT_OBJECT_MAPPER);
    }

    public PluginAppBuilder(String pluginName, OSGIKillbillAPI killbillAPI, OSGIKillbillDataSource dataSource, OSGIKillbillClock clock, OSGIConfigPropertiesService configProperties) {
        this(pluginName);
        this.withService(killbillAPI);
        this.withService(dataSource);
        this.withService(clock);
        this.withService(configProperties);
        this.withRouteClass(PluginHealthcheck.class);
    }

    public PluginAppBuilder withObjectMapper(ObjectMapper objectMapper) {
        this.jackson = new Jackson(objectMapper);
        return this;
    }

    public PluginAppBuilder withJackson(Jackson jackson) {
        this.jackson = jackson;
        return this;
    }

    public PluginAppBuilder withService(Object service) {
        this.services.add(service);
        return this;
    }

    public PluginAppBuilder withRouteClass(Class routeClass) {
        this.routeClasses.add(routeClass);
        return this;
    }

    public PluginAppBuilder withConfig(Config config) {
        this.config = config;
        return this;
    }

    public PluginAppBuilder withConfigValue(String path, Object value) {
        this.config = this.config.withValue(path, ConfigValueFactory.fromAnyRef(value));
        return this;
    }

    public PluginApp build() {
        PluginApp app = new PluginApp(this.jackson, this.services, this.routeClasses);
        app.use(this.config);
        return app;
    }

    static {
        DEFAULT_OBJECT_MAPPER.registerModule(new JodaModule());
        DEFAULT_OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}

