/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core.resources;

import java.util.Map;
import javax.annotation.Nullable;
import org.jooby.MediaType;
import org.jooby.Result;
import org.jooby.Results;
import org.jooby.Status;
import org.killbill.billing.osgi.api.Healthcheck;
import org.killbill.billing.tenant.api.Tenant;

public abstract class PluginHealthcheck {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String DEFAULT_CACHE_CONTROL = "private, no-cache, no-store, no-transform, must-revalidate";

    protected Result check(Healthcheck healthcheck, @Nullable Tenant tenant, @Nullable Map properties) {
        Healthcheck.HealthStatus healthStatus = healthcheck.getHealthStatus(tenant, properties);
        return this.buildHealthcheckResponse(healthStatus);
    }

    protected Result buildHealthcheckResponse(Healthcheck.HealthStatus healthStatus) {
        return Results.with((Object)healthStatus.getDetails(), healthStatus.isHealthy() ? Status.OK : Status.SERVICE_UNAVAILABLE).header(CACHE_CONTROL, (Object)DEFAULT_CACHE_CONTROL).type(MediaType.json);
    }
}

