/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.plugin.api.notification.PluginConfigurationHandler;
import org.killbill.billing.plugin.api.notification.PluginTenantConfigurable;
import org.killbill.billing.plugin.core.config.KillBillTrustedTagInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public abstract class YAMLPluginTenantConfigurationHandler<U, T>
extends PluginConfigurationHandler {
    private static final Logger logger = LoggerFactory.getLogger(YAMLPluginTenantConfigurationHandler.class);
    private final Collection<UUID> configuredTenants = new HashSet<UUID>();
    private final PluginTenantConfigurable<T> pluginTenantConfigurable = new PluginTenantConfigurable();
    private final String configurationKey;

    public YAMLPluginTenantConfigurationHandler(String pluginName, OSGIKillbillAPI osgiKillbillAPI) {
        this(pluginName, osgiKillbillAPI, null);
    }

    public YAMLPluginTenantConfigurationHandler(String pluginName, OSGIKillbillAPI osgiKillbillAPI, String configurationKey) {
        super(pluginName, osgiKillbillAPI);
        this.configurationKey = configurationKey;
    }

    public String getConfigurationKey() {
        return this.configurationKey;
    }

    public void setDefaultConfigurable(T defaultConfigurable) {
        this.pluginTenantConfigurable.setDefaultConfigurable(defaultConfigurable);
    }

    @Override
    protected void configure(@Nullable UUID kbTenantId) {
        String rawConfiguration = this.getTenantConfigurationAsString(kbTenantId);
        Object configurable = null;
        if (rawConfiguration != null) {
            U configObject = this.parseRawConfiguration(rawConfiguration);
            configurable = this.createConfigurable(configObject);
        }
        this.pluginTenantConfigurable.put(kbTenantId, configurable);
    }

    protected U parseRawConfiguration(String rawConfiguration) {
        LoaderOptions options = new LoaderOptions();
        options.setTagInspector(new KillBillTrustedTagInspector());
        Yaml yaml = new Yaml(options);
        Object configObject = yaml.load(rawConfiguration);
        if (this.configurationKey != null && configObject instanceof Map) {
            return (U)((Map)configObject).get(this.configurationKey);
        }
        return (U)configObject;
    }

    protected T createConfigurable(U configObject) {
        return (T)configObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getConfigurable(@Nullable UUID kbTenantId) {
        if (kbTenantId != null && !this.configuredTenants.contains(kbTenantId)) {
            Collection<UUID> collection = this.configuredTenants;
            synchronized (collection) {
                if (!this.configuredTenants.contains(kbTenantId)) {
                    this.configure(kbTenantId);
                    this.configuredTenants.add(kbTenantId);
                }
            }
        }
        return this.pluginTenantConfigurable.get(kbTenantId);
    }

    protected static Map<String, ?> propertiesToMap(Properties properties, @Nullable String prefix) {
        int trimLength = prefix == null ? 0 : prefix.length();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            if (prefix != null && !name.startsWith(prefix)) continue;
            map.put(name.substring(trimLength), properties.getProperty(name));
        }
        return map;
    }
}

