/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core;

import com.typesafe.config.Config;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jooby.Sse;
import org.jooby.servlet.ServletServletRequest;
import org.jooby.servlet.ServletServletResponse;
import org.jooby.servlet.ServletUpgrade;
import org.jooby.spi.HttpHandler;
import org.killbill.billing.plugin.core.PluginServlet;
import org.killbill.billing.plugin.core.resources.ServletSse;
import org.killbill.billing.plugin.core.resources.jooby.PluginApp;

public class JoobyServlet
extends PluginServlet {
    private static final long serialVersionUID = 1L;
    private final transient PluginApp app;
    private final transient HttpHandler dispatcher;
    private final String tmpdir;

    public JoobyServlet(PluginApp app) {
        this.app = app;
        this.app.start();
        this.dispatcher = app.require(HttpHandler.class);
        this.tmpdir = app.require(Config.class).getString("application.tmpdir");
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletServletRequest request = new ServletServletRequest(req, this.tmpdir).with(new ServletSseUpgrade((ServletRequest)req));
        ServletServletResponse response = new ServletServletResponse(req, resp);
        try {
            this.dispatcher.handle(request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        this.app.stop();
    }

    public static class ServletSseUpgrade
    implements ServletUpgrade {
        private final ServletRequest req;

        public ServletSseUpgrade(ServletRequest req) {
            this.req = req;
        }

        @Override
        public <T> T upgrade(Class<T> type) {
            if (type == Sse.class) {
                return (T)new ServletSse(this.req);
            }
            throw new UnsupportedOperationException("#upgrade not yet supported: " + String.valueOf(type));
        }
    }
}

