/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.payment;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.payment.plugin.api.PaymentPluginStatus;
import org.killbill.billing.payment.plugin.api.PaymentTransactionInfoPlugin;

@JsonDeserialize(builder=Builder.class)
public class PluginPaymentTransactionInfoPlugin
implements PaymentTransactionInfoPlugin {
    protected final UUID kbPaymentId;
    protected final UUID kbTransactionPaymentPaymentId;
    protected final TransactionType transactionType;
    protected final BigDecimal amount;
    protected final Currency currency;
    protected final PaymentPluginStatus pluginStatus;
    protected final String gatewayError;
    protected final String gatewayErrorCode;
    protected final String firstPaymentReferenceId;
    protected final String secondPaymentReferenceId;
    protected final DateTime createdDate;
    protected final DateTime effectiveDate;
    protected final List<PluginProperty> properties;

    public PluginPaymentTransactionInfoPlugin(UUID kbPaymentId, UUID kbTransactionPaymentPaymentId, TransactionType transactionType, BigDecimal amount, Currency currency, PaymentPluginStatus pluginStatus, String gatewayError, String gatewayErrorCode, String firstPaymentReferenceId, String secondPaymentReferenceId, DateTime createdDate, DateTime effectiveDate, List<PluginProperty> properties) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().withKbPaymentId(kbPaymentId)).withKbTransactionPaymentId(kbTransactionPaymentPaymentId)).withTransactionType(transactionType)).withAmount(amount)).withCurrency(currency)).withStatus(pluginStatus)).withGatewayError(gatewayError)).withGatewayErrorCode(gatewayErrorCode)).withFirstPaymentReferenceId(firstPaymentReferenceId)).withSecondPaymentReferenceId(secondPaymentReferenceId)).withCreatedDate(createdDate)).withEffectiveDate(effectiveDate)).withProperties(properties)).validate());
    }

    public PluginPaymentTransactionInfoPlugin(PluginPaymentTransactionInfoPlugin that) {
        this.amount = that.amount;
        this.createdDate = that.createdDate;
        this.currency = that.currency;
        this.effectiveDate = that.effectiveDate;
        this.firstPaymentReferenceId = that.firstPaymentReferenceId;
        this.gatewayError = that.gatewayError;
        this.gatewayErrorCode = that.gatewayErrorCode;
        this.kbPaymentId = that.kbPaymentId;
        this.kbTransactionPaymentPaymentId = that.kbTransactionPaymentPaymentId;
        this.properties = that.properties;
        this.secondPaymentReferenceId = that.secondPaymentReferenceId;
        this.pluginStatus = that.pluginStatus;
        this.transactionType = that.transactionType;
    }

    protected PluginPaymentTransactionInfoPlugin(Builder<?> builder) {
        this.amount = builder.amount;
        this.createdDate = builder.createdDate;
        this.currency = builder.currency;
        this.effectiveDate = builder.effectiveDate;
        this.firstPaymentReferenceId = builder.firstPaymentReferenceId;
        this.gatewayError = builder.gatewayError;
        this.gatewayErrorCode = builder.gatewayErrorCode;
        this.kbPaymentId = builder.kbPaymentId;
        this.kbTransactionPaymentPaymentId = builder.kbTransactionPaymentId;
        this.properties = builder.properties;
        this.secondPaymentReferenceId = builder.secondPaymentReferenceId;
        this.pluginStatus = builder.status;
        this.transactionType = builder.transactionType;
    }

    public UUID getKbPaymentId() {
        return this.kbPaymentId;
    }

    public UUID getKbTransactionPaymentId() {
        return this.kbTransactionPaymentPaymentId;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public PaymentPluginStatus getStatus() {
        return this.pluginStatus;
    }

    public String getGatewayError() {
        return this.gatewayError;
    }

    public String getGatewayErrorCode() {
        return this.gatewayErrorCode;
    }

    public String getFirstPaymentReferenceId() {
        return this.firstPaymentReferenceId;
    }

    public String getSecondPaymentReferenceId() {
        return this.secondPaymentReferenceId;
    }

    public List<PluginProperty> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginPaymentTransactionInfoPlugin that = (PluginPaymentTransactionInfoPlugin)o;
        if (this.amount != null ? 0 != this.amount.compareTo(that.amount) : that.amount != null) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        if (this.effectiveDate != null ? 0 != this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (!Objects.equals(this.firstPaymentReferenceId, that.firstPaymentReferenceId)) {
            return false;
        }
        if (!Objects.equals(this.gatewayError, that.gatewayError)) {
            return false;
        }
        if (!Objects.equals(this.gatewayErrorCode, that.gatewayErrorCode)) {
            return false;
        }
        if (!Objects.equals(this.kbPaymentId, that.kbPaymentId)) {
            return false;
        }
        if (!Objects.equals(this.kbTransactionPaymentPaymentId, that.kbTransactionPaymentPaymentId)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        if (!Objects.equals(this.secondPaymentReferenceId, that.secondPaymentReferenceId)) {
            return false;
        }
        if (!Objects.equals(this.pluginStatus, that.pluginStatus)) {
            return false;
        }
        return Objects.equals(this.transactionType, that.transactionType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.amount);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.effectiveDate);
        result = 31 * result + Objects.hashCode(this.firstPaymentReferenceId);
        result = 31 * result + Objects.hashCode(this.gatewayError);
        result = 31 * result + Objects.hashCode(this.gatewayErrorCode);
        result = 31 * result + Objects.hashCode(this.kbPaymentId);
        result = 31 * result + Objects.hashCode(this.kbTransactionPaymentPaymentId);
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.secondPaymentReferenceId);
        result = 31 * result + Objects.hashCode(this.pluginStatus);
        result = 31 * result + Objects.hashCode(this.transactionType);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("amount=").append(this.amount);
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("effectiveDate=").append(this.effectiveDate);
        sb.append(", ");
        sb.append("firstPaymentReferenceId=");
        if (this.firstPaymentReferenceId == null) {
            sb.append(this.firstPaymentReferenceId);
        } else {
            sb.append("'").append(this.firstPaymentReferenceId).append("'");
        }
        sb.append(", ");
        sb.append("gatewayError=");
        if (this.gatewayError == null) {
            sb.append(this.gatewayError);
        } else {
            sb.append("'").append(this.gatewayError).append("'");
        }
        sb.append(", ");
        sb.append("gatewayErrorCode=");
        if (this.gatewayErrorCode == null) {
            sb.append(this.gatewayErrorCode);
        } else {
            sb.append("'").append(this.gatewayErrorCode).append("'");
        }
        sb.append(", ");
        sb.append("kbPaymentId=").append(this.kbPaymentId);
        sb.append(", ");
        sb.append("kbTransactionPaymentId=").append(this.kbTransactionPaymentPaymentId);
        sb.append(", ");
        sb.append("properties=").append(this.properties);
        sb.append(", ");
        sb.append("secondPaymentReferenceId=");
        if (this.secondPaymentReferenceId == null) {
            sb.append(this.secondPaymentReferenceId);
        } else {
            sb.append("'").append(this.secondPaymentReferenceId).append("'");
        }
        sb.append(", ");
        sb.append("status=").append(this.pluginStatus);
        sb.append(", ");
        sb.append("transactionType=").append(this.transactionType);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BigDecimal amount;
        protected DateTime createdDate;
        protected Currency currency;
        protected DateTime effectiveDate;
        protected String firstPaymentReferenceId;
        protected String gatewayError;
        protected String gatewayErrorCode;
        protected UUID kbPaymentId;
        protected UUID kbTransactionPaymentId;
        protected List<PluginProperty> properties;
        protected String secondPaymentReferenceId;
        protected PaymentPluginStatus status;
        protected TransactionType transactionType;

        public Builder() {
        }

        public Builder(Builder that) {
            this.amount = that.amount;
            this.createdDate = that.createdDate;
            this.currency = that.currency;
            this.effectiveDate = that.effectiveDate;
            this.firstPaymentReferenceId = that.firstPaymentReferenceId;
            this.gatewayError = that.gatewayError;
            this.gatewayErrorCode = that.gatewayErrorCode;
            this.kbPaymentId = that.kbPaymentId;
            this.kbTransactionPaymentId = that.kbTransactionPaymentId;
            this.properties = that.properties;
            this.secondPaymentReferenceId = that.secondPaymentReferenceId;
            this.status = that.status;
            this.transactionType = that.transactionType;
        }

        public T withAmount(BigDecimal amount) {
            this.amount = amount;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withEffectiveDate(DateTime effectiveDate) {
            this.effectiveDate = effectiveDate;
            return (T)this;
        }

        public T withFirstPaymentReferenceId(String firstPaymentReferenceId) {
            this.firstPaymentReferenceId = firstPaymentReferenceId;
            return (T)this;
        }

        public T withGatewayError(String gatewayError) {
            this.gatewayError = gatewayError;
            return (T)this;
        }

        public T withGatewayErrorCode(String gatewayErrorCode) {
            this.gatewayErrorCode = gatewayErrorCode;
            return (T)this;
        }

        public T withKbPaymentId(UUID kbPaymentId) {
            this.kbPaymentId = kbPaymentId;
            return (T)this;
        }

        public T withKbTransactionPaymentId(UUID kbTransactionPaymentId) {
            this.kbTransactionPaymentId = kbTransactionPaymentId;
            return (T)this;
        }

        public T withProperties(List<PluginProperty> properties) {
            this.properties = properties;
            return (T)this;
        }

        public T withSecondPaymentReferenceId(String secondPaymentReferenceId) {
            this.secondPaymentReferenceId = secondPaymentReferenceId;
            return (T)this;
        }

        public T withStatus(PaymentPluginStatus status) {
            this.status = status;
            return (T)this;
        }

        public T withTransactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return (T)this;
        }

        public T source(PaymentTransactionInfoPlugin that) {
            this.amount = that.getAmount();
            this.createdDate = that.getCreatedDate();
            this.currency = that.getCurrency();
            this.effectiveDate = that.getEffectiveDate();
            this.firstPaymentReferenceId = that.getFirstPaymentReferenceId();
            this.gatewayError = that.getGatewayError();
            this.gatewayErrorCode = that.getGatewayErrorCode();
            this.kbPaymentId = that.getKbPaymentId();
            this.kbTransactionPaymentId = that.getKbTransactionPaymentId();
            this.properties = that.getProperties();
            this.secondPaymentReferenceId = that.getSecondPaymentReferenceId();
            this.status = that.getStatus();
            this.transactionType = that.getTransactionType();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PluginPaymentTransactionInfoPlugin build() {
            return new PluginPaymentTransactionInfoPlugin(this.validate());
        }
    }
}

