/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.core;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentAttempt;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionStatus;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.payment.plugin.api.PaymentPluginStatus;
import org.killbill.billing.plugin.api.core.PluginPaymentOptions;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.commons.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentApiWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PaymentApiWrapper.class);
    private final OSGIKillbillAPI osgiKillbillAPI;
    private final boolean withControl;

    public PaymentApiWrapper(OSGIKillbillAPI osgiKillbillAPIL, boolean withControl) {
        this.osgiKillbillAPI = osgiKillbillAPIL;
        this.withControl = withControl;
    }

    public List<String> getPaymentControlPluginNames(UUID kbPaymentId, TenantContext context) throws PaymentApiException {
        if (!this.withControl) {
            return null;
        }
        Payment payment = this.osgiKillbillAPI.getPaymentApi().getPayment(kbPaymentId, false, true, Collections.emptyList(), context);
        if (payment.getPaymentAttempts() != null && !payment.getPaymentAttempts().isEmpty()) {
            return Strings.split((String)((PaymentAttempt)payment.getPaymentAttempts().get(0)).getPluginName(), (String)",");
        }
        return Collections.emptyList();
    }

    public PaymentTransaction transitionPendingTransaction(Account account, UUID kbPaymentId, UUID kbPaymentTransactionId, PaymentPluginStatus paymentPluginStatus, CallContext context) throws PaymentApiException {
        PluginPaymentOptions paymentOptions = this.getPaymentOptions(kbPaymentId, (TenantContext)context);
        Payment payment = paymentOptions == null ? this.osgiKillbillAPI.getPaymentApi().notifyPendingTransactionOfStateChanged(account, kbPaymentTransactionId, paymentPluginStatus == PaymentPluginStatus.PROCESSED, context) : this.osgiKillbillAPI.getPaymentApi().notifyPendingTransactionOfStateChangedWithPaymentControl(account, kbPaymentTransactionId, paymentPluginStatus == PaymentPluginStatus.PROCESSED, (PaymentOptions)paymentOptions, context);
        return PaymentApiWrapper.filterForTransaction(payment, kbPaymentTransactionId);
    }

    public PaymentTransaction fixPaymentTransactionState(Payment payment, PaymentPluginStatus paymentPluginStatus, PaymentTransaction updatedPaymentTransaction, CallContext context) throws PaymentApiException {
        TransactionStatus transactionStatus;
        String currentPaymentStateName = String.format("%s_%s", updatedPaymentTransaction.getTransactionType() == TransactionType.AUTHORIZE ? "AUTH" : updatedPaymentTransaction.getTransactionType(), paymentPluginStatus == PaymentPluginStatus.PROCESSED ? "SUCCESS" : "FAILED");
        String lastSuccessfulPaymentStateName = paymentPluginStatus == PaymentPluginStatus.PROCESSED ? currentPaymentStateName : null;
        switch (paymentPluginStatus) {
            case PROCESSED: {
                transactionStatus = TransactionStatus.SUCCESS;
                break;
            }
            case PENDING: {
                transactionStatus = TransactionStatus.PENDING;
                break;
            }
            case ERROR: {
                transactionStatus = TransactionStatus.PAYMENT_FAILURE;
                break;
            }
            case CANCELED: {
                transactionStatus = TransactionStatus.PLUGIN_FAILURE;
                break;
            }
            default: {
                transactionStatus = TransactionStatus.UNKNOWN;
            }
        }
        logger.warn("Forcing transition paymentTransactionExternalKey='{}', oldPaymentPluginStatus='{}', newPaymentPluginStatus='{}'", new Object[]{updatedPaymentTransaction.getExternalKey(), updatedPaymentTransaction.getPaymentInfoPlugin().getStatus(), paymentPluginStatus});
        this.osgiKillbillAPI.getAdminPaymentApi().fixPaymentTransactionState(payment, updatedPaymentTransaction, transactionStatus, lastSuccessfulPaymentStateName, currentPaymentStateName, Collections.emptyList(), context);
        Payment fixedPayment = this.osgiKillbillAPI.getPaymentApi().getPayment(payment.getId(), true, false, Collections.emptyList(), (TenantContext)context);
        return PaymentApiWrapper.filterForTransaction(fixedPayment, updatedPaymentTransaction.getId());
    }

    public PaymentTransaction createPayment(TransactionType transactionType, Account account, UUID kbPaymentMethodId, @Nullable UUID kbPaymentId, BigDecimal amount, Currency currency, String paymentExternalKey, String paymentTransactionExternalKey, Iterable<PluginProperty> pluginProperties, CallContext context) throws PaymentApiException {
        Payment createdPayment;
        PluginPaymentOptions paymentOptions = kbPaymentId != null ? this.getPaymentOptions(kbPaymentId, (TenantContext)context) : null;
        DateTime effectiveDate = context.getCreatedDate();
        switch (transactionType) {
            case AUTHORIZE: {
                if (paymentOptions == null) {
                    createdPayment = this.osgiKillbillAPI.getPaymentApi().createAuthorization(account, kbPaymentMethodId, kbPaymentId, amount, currency, effectiveDate, paymentExternalKey, paymentTransactionExternalKey, pluginProperties, context);
                    break;
                }
                createdPayment = this.osgiKillbillAPI.getPaymentApi().createAuthorizationWithPaymentControl(account, kbPaymentMethodId, kbPaymentId, amount, currency, effectiveDate, paymentExternalKey, paymentTransactionExternalKey, pluginProperties, (PaymentOptions)paymentOptions, context);
                break;
            }
            case CAPTURE: {
                if (paymentOptions == null) {
                    createdPayment = this.osgiKillbillAPI.getPaymentApi().createCapture(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, pluginProperties, context);
                    break;
                }
                createdPayment = this.osgiKillbillAPI.getPaymentApi().createCaptureWithPaymentControl(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, pluginProperties, (PaymentOptions)paymentOptions, context);
                break;
            }
            case CHARGEBACK: {
                if (paymentOptions == null) {
                    createdPayment = this.osgiKillbillAPI.getPaymentApi().createChargeback(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, context);
                    break;
                }
                createdPayment = this.osgiKillbillAPI.getPaymentApi().createChargebackWithPaymentControl(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, (PaymentOptions)paymentOptions, context);
                break;
            }
            case CREDIT: {
                if (paymentOptions == null) {
                    createdPayment = this.osgiKillbillAPI.getPaymentApi().createCredit(account, kbPaymentMethodId, kbPaymentId, amount, currency, effectiveDate, paymentExternalKey, paymentTransactionExternalKey, pluginProperties, context);
                    break;
                }
                createdPayment = this.osgiKillbillAPI.getPaymentApi().createCreditWithPaymentControl(account, kbPaymentMethodId, kbPaymentId, amount, currency, effectiveDate, paymentExternalKey, paymentTransactionExternalKey, pluginProperties, (PaymentOptions)paymentOptions, context);
                break;
            }
            case PURCHASE: {
                if (paymentOptions == null) {
                    createdPayment = this.osgiKillbillAPI.getPaymentApi().createPurchase(account, kbPaymentMethodId, kbPaymentId, amount, currency, effectiveDate, paymentExternalKey, paymentTransactionExternalKey, pluginProperties, context);
                    break;
                }
                createdPayment = this.osgiKillbillAPI.getPaymentApi().createPurchaseWithPaymentControl(account, kbPaymentMethodId, kbPaymentId, amount, currency, effectiveDate, paymentExternalKey, paymentTransactionExternalKey, pluginProperties, (PaymentOptions)paymentOptions, context);
                break;
            }
            case REFUND: {
                if (paymentOptions == null) {
                    createdPayment = this.osgiKillbillAPI.getPaymentApi().createRefund(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, pluginProperties, context);
                    break;
                }
                createdPayment = this.osgiKillbillAPI.getPaymentApi().createRefundWithPaymentControl(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, pluginProperties, (PaymentOptions)paymentOptions, context);
                break;
            }
            case VOID: {
                if (paymentOptions == null) {
                    createdPayment = this.osgiKillbillAPI.getPaymentApi().createVoid(account, kbPaymentId, effectiveDate, paymentTransactionExternalKey, pluginProperties, context);
                    break;
                }
                createdPayment = this.osgiKillbillAPI.getPaymentApi().createVoidWithPaymentControl(account, kbPaymentId, effectiveDate, paymentTransactionExternalKey, pluginProperties, (PaymentOptions)paymentOptions, context);
                break;
            }
            default: {
                throw new IllegalStateException("Should never happen");
            }
        }
        return PaymentApiWrapper.filterForLastTransaction(createdPayment);
    }

    public PaymentTransaction createChargeback(Account account, UUID kbPaymentId, BigDecimal amount, Currency currency, String paymentTransactionExternalKey, CallContext context) throws PaymentApiException {
        DateTime effectiveDate = context.getCreatedDate();
        PluginPaymentOptions paymentOptions = this.getPaymentOptions(kbPaymentId, (TenantContext)context);
        Payment chargeback = paymentOptions == null ? this.osgiKillbillAPI.getPaymentApi().createChargeback(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, context) : this.osgiKillbillAPI.getPaymentApi().createChargebackWithPaymentControl(account, kbPaymentId, amount, currency, effectiveDate, paymentTransactionExternalKey, (PaymentOptions)paymentOptions, context);
        return PaymentApiWrapper.filterForLastTransaction(chargeback);
    }

    public PaymentTransaction createChargebackReversal(Account account, UUID kbPaymentId, PaymentTransaction chargeback, CallContext context) throws PaymentApiException {
        DateTime effectiveDate = context.getCreatedDate();
        String paymentTransactionExternalKey = chargeback.getExternalKey();
        PluginPaymentOptions paymentOptions = this.getPaymentOptions(kbPaymentId, (TenantContext)context);
        Payment chargebackReversal = paymentOptions == null ? this.osgiKillbillAPI.getPaymentApi().createChargebackReversal(account, kbPaymentId, effectiveDate, paymentTransactionExternalKey, context) : this.osgiKillbillAPI.getPaymentApi().createChargebackReversalWithPaymentControl(account, kbPaymentId, effectiveDate, paymentTransactionExternalKey, (PaymentOptions)paymentOptions, context);
        return PaymentApiWrapper.filterForLastTransaction(chargebackReversal);
    }

    protected PluginPaymentOptions getPaymentOptions(UUID kbPaymentId, TenantContext context) throws PaymentApiException {
        List<String> paymentControlPluginNames = this.getPaymentControlPluginNames(kbPaymentId, context);
        if (paymentControlPluginNames == null) {
            return null;
        }
        return new PluginPaymentOptions(paymentControlPluginNames);
    }

    public static PaymentTransaction filterForLastTransaction(Payment payment) {
        int numberOfTransaction = payment.getTransactions().size();
        return (PaymentTransaction)payment.getTransactions().get(numberOfTransaction - 1);
    }

    public static PaymentTransaction filterForTransaction(Payment payment, UUID kbTransactionId) {
        for (PaymentTransaction paymentTransaction : payment.getTransactions()) {
            if (!paymentTransaction.getId().equals(kbTransactionId)) continue;
            return paymentTransaction;
        }
        return null;
    }

    public static PaymentTransaction filterForTransaction(Payment payment, TransactionType transactionType) {
        for (PaymentTransaction paymentTransaction : payment.getTransactions()) {
            if (!paymentTransaction.getTransactionType().equals((Object)transactionType)) continue;
            return paymentTransaction;
        }
        return null;
    }
}

