/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.control;

import java.math.BigDecimal;
import java.util.UUID;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.control.plugin.api.PriorPaymentControlResult;
import org.killbill.billing.payment.api.PluginProperty;

public class PluginPriorPaymentControlResult
implements PriorPaymentControlResult {
    private final boolean isAborted;
    private final BigDecimal adjustedAmount;
    private final Currency adjustedCurrency;
    private final UUID adjustedPaymentMethodId;
    private final String adjustedPluginName;
    private final Iterable<PluginProperty> adjustedPluginProperties;

    public PluginPriorPaymentControlResult(boolean isAborted) {
        this(isAborted, null, null, null, null, null);
    }

    public PluginPriorPaymentControlResult(boolean isAborted, BigDecimal adjustedAmount, Currency adjustedCurrency, UUID adjustedPaymentMethodId, String adjustedPluginName, Iterable<PluginProperty> adjustedPluginProperties) {
        this.isAborted = isAborted;
        this.adjustedAmount = adjustedAmount;
        this.adjustedCurrency = adjustedCurrency;
        this.adjustedPaymentMethodId = adjustedPaymentMethodId;
        this.adjustedPluginName = adjustedPluginName;
        this.adjustedPluginProperties = adjustedPluginProperties;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public BigDecimal getAdjustedAmount() {
        return this.adjustedAmount;
    }

    public Currency getAdjustedCurrency() {
        return this.adjustedCurrency;
    }

    public UUID getAdjustedPaymentMethodId() {
        return this.adjustedPaymentMethodId;
    }

    public String getAdjustedPluginName() {
        return this.adjustedPluginName;
    }

    public Iterable<PluginProperty> getAdjustedPluginProperties() {
        return this.adjustedPluginProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginPriorPaymentControlResult{");
        sb.append("isAborted=").append(this.isAborted);
        sb.append(", adjustedAmount=").append(this.adjustedAmount);
        sb.append(", adjustedCurrency=").append(this.adjustedCurrency);
        sb.append(", adjustedPaymentMethodId=").append(this.adjustedPaymentMethodId);
        sb.append(", adjustedPluginName='").append(this.adjustedPluginName).append('\'');
        sb.append(", adjustedPluginProperties=").append(this.adjustedPluginProperties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginPriorPaymentControlResult that = (PluginPriorPaymentControlResult)o;
        if (this.isAborted != that.isAborted) {
            return false;
        }
        if (this.adjustedAmount != null ? this.adjustedAmount.compareTo(that.adjustedAmount) != 0 : that.adjustedAmount != null) {
            return false;
        }
        if (this.adjustedCurrency != that.adjustedCurrency) {
            return false;
        }
        if (this.adjustedPaymentMethodId != null ? !this.adjustedPaymentMethodId.equals(that.adjustedPaymentMethodId) : that.adjustedPaymentMethodId != null) {
            return false;
        }
        if (this.adjustedPluginName != null ? !this.adjustedPluginName.equals(that.adjustedPluginName) : that.adjustedPluginName != null) {
            return false;
        }
        return this.adjustedPluginProperties != null ? this.adjustedPluginProperties.equals(that.adjustedPluginProperties) : that.adjustedPluginProperties == null;
    }

    public int hashCode() {
        int result = this.isAborted ? 1 : 0;
        result = 31 * result + (this.adjustedAmount != null ? this.adjustedAmount.hashCode() : 0);
        result = 31 * result + (this.adjustedCurrency != null ? this.adjustedCurrency.hashCode() : 0);
        result = 31 * result + (this.adjustedPaymentMethodId != null ? this.adjustedPaymentMethodId.hashCode() : 0);
        result = 31 * result + (this.adjustedPluginName != null ? this.adjustedPluginName.hashCode() : 0);
        result = 31 * result + (this.adjustedPluginProperties != null ? this.adjustedPluginProperties.hashCode() : 0);
        return result;
    }
}

