/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.payment.plugin.api.boilerplate.plugin;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.payment.plugin.api.PaymentMethodInfoPlugin;

@JsonDeserialize(builder=Builder.class)
public class PaymentMethodInfoPluginImp
implements PaymentMethodInfoPlugin {
    protected UUID accountId;
    protected String externalPaymentMethodId;
    protected boolean isDefault;
    protected UUID paymentMethodId;

    public PaymentMethodInfoPluginImp(PaymentMethodInfoPluginImp that) {
        this.accountId = that.accountId;
        this.externalPaymentMethodId = that.externalPaymentMethodId;
        this.isDefault = that.isDefault;
        this.paymentMethodId = that.paymentMethodId;
    }

    protected PaymentMethodInfoPluginImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.externalPaymentMethodId = builder.externalPaymentMethodId;
        this.isDefault = builder.isDefault;
        this.paymentMethodId = builder.paymentMethodId;
    }

    protected PaymentMethodInfoPluginImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public String getExternalPaymentMethodId() {
        return this.externalPaymentMethodId;
    }

    @JsonGetter(value="isDefault")
    public boolean isDefault() {
        return this.isDefault;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodInfoPluginImp that = (PaymentMethodInfoPluginImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (!Objects.equals(this.externalPaymentMethodId, that.externalPaymentMethodId)) {
            return false;
        }
        if (this.isDefault != that.isDefault) {
            return false;
        }
        return Objects.equals(this.paymentMethodId, that.paymentMethodId);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.externalPaymentMethodId);
        result = 31 * result + Objects.hashCode(this.isDefault);
        result = 31 * result + Objects.hashCode(this.paymentMethodId);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("externalPaymentMethodId=");
        if (this.externalPaymentMethodId == null) {
            sb.append(this.externalPaymentMethodId);
        } else {
            sb.append("'").append(this.externalPaymentMethodId).append("'");
        }
        sb.append(", ");
        sb.append("isDefault=").append(this.isDefault);
        sb.append(", ");
        sb.append("paymentMethodId=").append(this.paymentMethodId);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected String externalPaymentMethodId;
        protected boolean isDefault;
        protected UUID paymentMethodId;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.externalPaymentMethodId = that.externalPaymentMethodId;
            this.isDefault = that.isDefault;
            this.paymentMethodId = that.paymentMethodId;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withExternalPaymentMethodId(String externalPaymentMethodId) {
            this.externalPaymentMethodId = externalPaymentMethodId;
            return (T)this;
        }

        public T withIsDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return (T)this;
        }

        public T withPaymentMethodId(UUID paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            return (T)this;
        }

        public T source(PaymentMethodInfoPlugin that) {
            this.accountId = that.getAccountId();
            this.externalPaymentMethodId = that.getExternalPaymentMethodId();
            this.isDefault = that.isDefault();
            this.paymentMethodId = that.getPaymentMethodId();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PaymentMethodInfoPluginImp build() {
            return new PaymentMethodInfoPluginImp(this.validate());
        }
    }
}

