/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.notification.plugin.api.boilerplate.plugin;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.notification.plugin.api.ExtBusEventType;

@JsonDeserialize(builder=Builder.class)
public class ExtBusEventImp
implements ExtBusEvent {
    protected UUID accountId;
    protected ExtBusEventType eventType;
    protected String metaData;
    protected UUID objectId;
    protected ObjectType objectType;
    protected UUID tenantId;
    protected UUID userToken;

    public ExtBusEventImp(ExtBusEventImp that) {
        this.accountId = that.accountId;
        this.eventType = that.eventType;
        this.metaData = that.metaData;
        this.objectId = that.objectId;
        this.objectType = that.objectType;
        this.tenantId = that.tenantId;
        this.userToken = that.userToken;
    }

    protected ExtBusEventImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.eventType = builder.eventType;
        this.metaData = builder.metaData;
        this.objectId = builder.objectId;
        this.objectType = builder.objectType;
        this.tenantId = builder.tenantId;
        this.userToken = builder.userToken;
    }

    protected ExtBusEventImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public ExtBusEventType getEventType() {
        return this.eventType;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getUserToken() {
        return this.userToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtBusEventImp that = (ExtBusEventImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (!Objects.equals(this.eventType, that.eventType)) {
            return false;
        }
        if (!Objects.equals(this.metaData, that.metaData)) {
            return false;
        }
        if (!Objects.equals(this.objectId, that.objectId)) {
            return false;
        }
        if (!Objects.equals(this.objectType, that.objectType)) {
            return false;
        }
        if (!Objects.equals(this.tenantId, that.tenantId)) {
            return false;
        }
        return Objects.equals(this.userToken, that.userToken);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.eventType);
        result = 31 * result + Objects.hashCode(this.metaData);
        result = 31 * result + Objects.hashCode(this.objectId);
        result = 31 * result + Objects.hashCode(this.objectType);
        result = 31 * result + Objects.hashCode(this.tenantId);
        result = 31 * result + Objects.hashCode(this.userToken);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("eventType=").append(this.eventType);
        sb.append(", ");
        sb.append("metaData=");
        if (this.metaData == null) {
            sb.append(this.metaData);
        } else {
            sb.append("'").append(this.metaData).append("'");
        }
        sb.append(", ");
        sb.append("objectId=").append(this.objectId);
        sb.append(", ");
        sb.append("objectType=").append(this.objectType);
        sb.append(", ");
        sb.append("tenantId=").append(this.tenantId);
        sb.append(", ");
        sb.append("userToken=").append(this.userToken);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected ExtBusEventType eventType;
        protected String metaData;
        protected UUID objectId;
        protected ObjectType objectType;
        protected UUID tenantId;
        protected UUID userToken;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.eventType = that.eventType;
            this.metaData = that.metaData;
            this.objectId = that.objectId;
            this.objectType = that.objectType;
            this.tenantId = that.tenantId;
            this.userToken = that.userToken;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withEventType(ExtBusEventType eventType) {
            this.eventType = eventType;
            return (T)this;
        }

        public T withMetaData(String metaData) {
            this.metaData = metaData;
            return (T)this;
        }

        public T withObjectId(UUID objectId) {
            this.objectId = objectId;
            return (T)this;
        }

        public T withObjectType(ObjectType objectType) {
            this.objectType = objectType;
            return (T)this;
        }

        public T withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return (T)this;
        }

        public T withUserToken(UUID userToken) {
            this.userToken = userToken;
            return (T)this;
        }

        public T source(ExtBusEvent that) {
            this.accountId = that.getAccountId();
            this.eventType = that.getEventType();
            this.metaData = that.getMetaData();
            this.objectId = that.getObjectId();
            this.objectType = that.getObjectType();
            this.tenantId = that.getTenantId();
            this.userToken = that.getUserToken();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public ExtBusEventImp build() {
            return new ExtBusEventImp(this.validate());
        }
    }
}

