/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.invoice.api.InvoiceParentChild;

@JsonDeserialize(builder=Builder.class)
public class InvoiceParentChildImp
implements InvoiceParentChild {
    protected UUID childAccountId;
    protected UUID childInvoiceId;
    protected DateTime createdDate;
    protected UUID id;
    protected UUID parentInvoiceId;
    protected DateTime updatedDate;

    public InvoiceParentChildImp(InvoiceParentChildImp that) {
        this.childAccountId = that.childAccountId;
        this.childInvoiceId = that.childInvoiceId;
        this.createdDate = that.createdDate;
        this.id = that.id;
        this.parentInvoiceId = that.parentInvoiceId;
        this.updatedDate = that.updatedDate;
    }

    protected InvoiceParentChildImp(Builder<?> builder) {
        this.childAccountId = builder.childAccountId;
        this.childInvoiceId = builder.childInvoiceId;
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.parentInvoiceId = builder.parentInvoiceId;
        this.updatedDate = builder.updatedDate;
    }

    protected InvoiceParentChildImp() {
    }

    public UUID getChildAccountId() {
        return this.childAccountId;
    }

    public UUID getChildInvoiceId() {
        return this.childInvoiceId;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getParentInvoiceId() {
        return this.parentInvoiceId;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceParentChildImp that = (InvoiceParentChildImp)o;
        if (!Objects.equals(this.childAccountId, that.childAccountId)) {
            return false;
        }
        if (!Objects.equals(this.childInvoiceId, that.childInvoiceId)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.parentInvoiceId, that.parentInvoiceId)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo((ReadableInstant)that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.childAccountId);
        result = 31 * result + Objects.hashCode(this.childInvoiceId);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.parentInvoiceId);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("childAccountId=").append(this.childAccountId);
        sb.append(", ");
        sb.append("childInvoiceId=").append(this.childInvoiceId);
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("parentInvoiceId=").append(this.parentInvoiceId);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID childAccountId;
        protected UUID childInvoiceId;
        protected DateTime createdDate;
        protected UUID id;
        protected UUID parentInvoiceId;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.childAccountId = that.childAccountId;
            this.childInvoiceId = that.childInvoiceId;
            this.createdDate = that.createdDate;
            this.id = that.id;
            this.parentInvoiceId = that.parentInvoiceId;
            this.updatedDate = that.updatedDate;
        }

        public T withChildAccountId(UUID childAccountId) {
            this.childAccountId = childAccountId;
            return (T)this;
        }

        public T withChildInvoiceId(UUID childInvoiceId) {
            this.childInvoiceId = childInvoiceId;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withParentInvoiceId(UUID parentInvoiceId) {
            this.parentInvoiceId = parentInvoiceId;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(InvoiceParentChild that) {
            this.childAccountId = that.getChildAccountId();
            this.childInvoiceId = that.getChildInvoiceId();
            this.createdDate = that.getCreatedDate();
            this.id = that.getId();
            this.parentInvoiceId = that.getParentInvoiceId();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public InvoiceParentChildImp build() {
            return new InvoiceParentChildImp(this.validate());
        }
    }
}

