/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.plugin.api.boilerplate.plugin;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.entitlement.api.BaseEntitlementWithAddOnsSpecifier;
import org.killbill.billing.entitlement.plugin.api.EntitlementContext;
import org.killbill.billing.entitlement.plugin.api.OperationType;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;

@JsonDeserialize(builder=Builder.class)
public class EntitlementContextImp
implements EntitlementContext {
    protected UUID accountId;
    protected Iterable<BaseEntitlementWithAddOnsSpecifier> baseEntitlementWithAddOnsSpecifiers;
    protected BillingActionPolicy billingActionPolicy;
    protected CallOrigin callOrigin;
    protected String comments;
    protected DateTime createdDate;
    protected UUID destinationAccountId;
    protected OperationType operationType;
    protected Iterable<PluginProperty> pluginProperties;
    protected String reasonCode;
    protected UUID tenantId;
    protected DateTime updatedDate;
    protected String userName;
    protected UUID userToken;
    protected UserType userType;

    public EntitlementContextImp(EntitlementContextImp that) {
        this.accountId = that.accountId;
        this.baseEntitlementWithAddOnsSpecifiers = that.baseEntitlementWithAddOnsSpecifiers;
        this.billingActionPolicy = that.billingActionPolicy;
        this.callOrigin = that.callOrigin;
        this.comments = that.comments;
        this.createdDate = that.createdDate;
        this.destinationAccountId = that.destinationAccountId;
        this.operationType = that.operationType;
        this.pluginProperties = that.pluginProperties;
        this.reasonCode = that.reasonCode;
        this.tenantId = that.tenantId;
        this.updatedDate = that.updatedDate;
        this.userName = that.userName;
        this.userToken = that.userToken;
        this.userType = that.userType;
    }

    protected EntitlementContextImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.baseEntitlementWithAddOnsSpecifiers = builder.baseEntitlementWithAddOnsSpecifiers;
        this.billingActionPolicy = builder.billingActionPolicy;
        this.callOrigin = builder.callOrigin;
        this.comments = builder.comments;
        this.createdDate = builder.createdDate;
        this.destinationAccountId = builder.destinationAccountId;
        this.operationType = builder.operationType;
        this.pluginProperties = builder.pluginProperties;
        this.reasonCode = builder.reasonCode;
        this.tenantId = builder.tenantId;
        this.updatedDate = builder.updatedDate;
        this.userName = builder.userName;
        this.userToken = builder.userToken;
        this.userType = builder.userType;
    }

    protected EntitlementContextImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public Iterable<BaseEntitlementWithAddOnsSpecifier> getBaseEntitlementWithAddOnsSpecifiers() {
        return this.baseEntitlementWithAddOnsSpecifiers;
    }

    public BillingActionPolicy getBillingActionPolicy() {
        return this.billingActionPolicy;
    }

    public CallOrigin getCallOrigin() {
        return this.callOrigin;
    }

    public String getComments() {
        return this.comments;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public UUID getDestinationAccountId() {
        return this.destinationAccountId;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Iterable<PluginProperty> getPluginProperties() {
        return this.pluginProperties;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public String getUserName() {
        return this.userName;
    }

    public UUID getUserToken() {
        return this.userToken;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitlementContextImp that = (EntitlementContextImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (!Objects.equals(this.baseEntitlementWithAddOnsSpecifiers, that.baseEntitlementWithAddOnsSpecifiers)) {
            return false;
        }
        if (!Objects.equals(this.billingActionPolicy, that.billingActionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.callOrigin, that.callOrigin)) {
            return false;
        }
        if (!Objects.equals(this.comments, that.comments)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.destinationAccountId, that.destinationAccountId)) {
            return false;
        }
        if (!Objects.equals(this.operationType, that.operationType)) {
            return false;
        }
        if (!Objects.equals(this.pluginProperties, that.pluginProperties)) {
            return false;
        }
        if (!Objects.equals(this.reasonCode, that.reasonCode)) {
            return false;
        }
        if (!Objects.equals(this.tenantId, that.tenantId)) {
            return false;
        }
        if (this.updatedDate != null ? 0 != this.updatedDate.compareTo((ReadableInstant)that.updatedDate) : that.updatedDate != null) {
            return false;
        }
        if (!Objects.equals(this.userName, that.userName)) {
            return false;
        }
        if (!Objects.equals(this.userToken, that.userToken)) {
            return false;
        }
        return Objects.equals(this.userType, that.userType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.baseEntitlementWithAddOnsSpecifiers);
        result = 31 * result + Objects.hashCode(this.billingActionPolicy);
        result = 31 * result + Objects.hashCode(this.callOrigin);
        result = 31 * result + Objects.hashCode(this.comments);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.destinationAccountId);
        result = 31 * result + Objects.hashCode(this.operationType);
        result = 31 * result + Objects.hashCode(this.pluginProperties);
        result = 31 * result + Objects.hashCode(this.reasonCode);
        result = 31 * result + Objects.hashCode(this.tenantId);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        result = 31 * result + Objects.hashCode(this.userName);
        result = 31 * result + Objects.hashCode(this.userToken);
        result = 31 * result + Objects.hashCode(this.userType);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("baseEntitlementWithAddOnsSpecifiers=").append(this.baseEntitlementWithAddOnsSpecifiers);
        sb.append(", ");
        sb.append("billingActionPolicy=").append(this.billingActionPolicy);
        sb.append(", ");
        sb.append("callOrigin=").append(this.callOrigin);
        sb.append(", ");
        sb.append("comments=");
        if (this.comments == null) {
            sb.append(this.comments);
        } else {
            sb.append("'").append(this.comments).append("'");
        }
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("destinationAccountId=").append(this.destinationAccountId);
        sb.append(", ");
        sb.append("operationType=").append(this.operationType);
        sb.append(", ");
        sb.append("pluginProperties=").append(this.pluginProperties);
        sb.append(", ");
        sb.append("reasonCode=");
        if (this.reasonCode == null) {
            sb.append(this.reasonCode);
        } else {
            sb.append("'").append(this.reasonCode).append("'");
        }
        sb.append(", ");
        sb.append("tenantId=").append(this.tenantId);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append(", ");
        sb.append("userName=");
        if (this.userName == null) {
            sb.append(this.userName);
        } else {
            sb.append("'").append(this.userName).append("'");
        }
        sb.append(", ");
        sb.append("userToken=").append(this.userToken);
        sb.append(", ");
        sb.append("userType=").append(this.userType);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected Iterable<BaseEntitlementWithAddOnsSpecifier> baseEntitlementWithAddOnsSpecifiers;
        protected BillingActionPolicy billingActionPolicy;
        protected CallOrigin callOrigin;
        protected String comments;
        protected DateTime createdDate;
        protected UUID destinationAccountId;
        protected OperationType operationType;
        protected Iterable<PluginProperty> pluginProperties;
        protected String reasonCode;
        protected UUID tenantId;
        protected DateTime updatedDate;
        protected String userName;
        protected UUID userToken;
        protected UserType userType;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.baseEntitlementWithAddOnsSpecifiers = that.baseEntitlementWithAddOnsSpecifiers;
            this.billingActionPolicy = that.billingActionPolicy;
            this.callOrigin = that.callOrigin;
            this.comments = that.comments;
            this.createdDate = that.createdDate;
            this.destinationAccountId = that.destinationAccountId;
            this.operationType = that.operationType;
            this.pluginProperties = that.pluginProperties;
            this.reasonCode = that.reasonCode;
            this.tenantId = that.tenantId;
            this.updatedDate = that.updatedDate;
            this.userName = that.userName;
            this.userToken = that.userToken;
            this.userType = that.userType;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withBaseEntitlementWithAddOnsSpecifiers(Iterable<BaseEntitlementWithAddOnsSpecifier> baseEntitlementWithAddOnsSpecifiers) {
            this.baseEntitlementWithAddOnsSpecifiers = baseEntitlementWithAddOnsSpecifiers;
            return (T)this;
        }

        public T withBillingActionPolicy(BillingActionPolicy billingActionPolicy) {
            this.billingActionPolicy = billingActionPolicy;
            return (T)this;
        }

        public T withCallOrigin(CallOrigin callOrigin) {
            this.callOrigin = callOrigin;
            return (T)this;
        }

        public T withComments(String comments) {
            this.comments = comments;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withDestinationAccountId(UUID destinationAccountId) {
            this.destinationAccountId = destinationAccountId;
            return (T)this;
        }

        public T withOperationType(OperationType operationType) {
            this.operationType = operationType;
            return (T)this;
        }

        public T withPluginProperties(Iterable<PluginProperty> pluginProperties) {
            this.pluginProperties = pluginProperties;
            return (T)this;
        }

        public T withReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return (T)this;
        }

        public T withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T withUserName(String userName) {
            this.userName = userName;
            return (T)this;
        }

        public T withUserToken(UUID userToken) {
            this.userToken = userToken;
            return (T)this;
        }

        public T withUserType(UserType userType) {
            this.userType = userType;
            return (T)this;
        }

        public T source(EntitlementContext that) {
            this.accountId = that.getAccountId();
            this.baseEntitlementWithAddOnsSpecifiers = that.getBaseEntitlementWithAddOnsSpecifiers();
            this.billingActionPolicy = that.getBillingActionPolicy();
            this.callOrigin = that.getCallOrigin();
            this.comments = that.getComments();
            this.createdDate = that.getCreatedDate();
            this.destinationAccountId = that.getDestinationAccountId();
            this.operationType = that.getOperationType();
            this.pluginProperties = that.getPluginProperties();
            this.reasonCode = that.getReasonCode();
            this.tenantId = that.getTenantId();
            this.updatedDate = that.getUpdatedDate();
            this.userName = that.getUserName();
            this.userToken = that.getUserToken();
            this.userType = that.getUserType();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public EntitlementContextImp build() {
            return new EntitlementContextImp(this.validate());
        }
    }
}

