/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.callcontext.CallContext;

@JsonDeserialize(builder=Builder.class)
public class SubscriptionImp
implements Subscription {
    protected UUID accountId;
    protected UUID baseEntitlementId;
    protected Integer billCycleDayLocal;
    protected DateTime billingEndDate;
    protected DateTime billingStartDate;
    protected String bundleExternalKey;
    protected UUID bundleId;
    protected LocalDate chargedThroughDate;
    protected DateTime createdDate;
    protected DateTime effectiveEndDate;
    protected DateTime effectiveStartDate;
    protected String externalKey;
    protected UUID id;
    protected PlanPhase lastActivePhase;
    protected Plan lastActivePlan;
    protected PriceList lastActivePriceList;
    protected Product lastActiveProduct;
    protected ProductCategory lastActiveProductCategory;
    protected Integer quantity;
    protected Entitlement.EntitlementSourceType sourceType;
    protected Entitlement.EntitlementState state;
    protected List<SubscriptionEvent> subscriptionEvents;
    protected DateTime updatedDate;

    public SubscriptionImp(SubscriptionImp that) {
        this.accountId = that.accountId;
        this.baseEntitlementId = that.baseEntitlementId;
        this.billCycleDayLocal = that.billCycleDayLocal;
        this.billingEndDate = that.billingEndDate;
        this.billingStartDate = that.billingStartDate;
        this.bundleExternalKey = that.bundleExternalKey;
        this.bundleId = that.bundleId;
        this.chargedThroughDate = that.chargedThroughDate;
        this.createdDate = that.createdDate;
        this.effectiveEndDate = that.effectiveEndDate;
        this.effectiveStartDate = that.effectiveStartDate;
        this.externalKey = that.externalKey;
        this.id = that.id;
        this.lastActivePhase = that.lastActivePhase;
        this.lastActivePlan = that.lastActivePlan;
        this.lastActivePriceList = that.lastActivePriceList;
        this.lastActiveProduct = that.lastActiveProduct;
        this.lastActiveProductCategory = that.lastActiveProductCategory;
        this.quantity = that.quantity;
        this.sourceType = that.sourceType;
        this.state = that.state;
        this.subscriptionEvents = that.subscriptionEvents;
        this.updatedDate = that.updatedDate;
    }

    protected SubscriptionImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.baseEntitlementId = builder.baseEntitlementId;
        this.billCycleDayLocal = builder.billCycleDayLocal;
        this.billingEndDate = builder.billingEndDate;
        this.billingStartDate = builder.billingStartDate;
        this.bundleExternalKey = builder.bundleExternalKey;
        this.bundleId = builder.bundleId;
        this.chargedThroughDate = builder.chargedThroughDate;
        this.createdDate = builder.createdDate;
        this.effectiveEndDate = builder.effectiveEndDate;
        this.effectiveStartDate = builder.effectiveStartDate;
        this.externalKey = builder.externalKey;
        this.id = builder.id;
        this.lastActivePhase = builder.lastActivePhase;
        this.lastActivePlan = builder.lastActivePlan;
        this.lastActivePriceList = builder.lastActivePriceList;
        this.lastActiveProduct = builder.lastActiveProduct;
        this.lastActiveProductCategory = builder.lastActiveProductCategory;
        this.quantity = builder.quantity;
        this.sourceType = builder.sourceType;
        this.state = builder.state;
        this.subscriptionEvents = builder.subscriptionEvents;
        this.updatedDate = builder.updatedDate;
    }

    protected SubscriptionImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getBaseEntitlementId() {
        return this.baseEntitlementId;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public DateTime getBillingEndDate() {
        return this.billingEndDate;
    }

    public DateTime getBillingStartDate() {
        return this.billingStartDate;
    }

    public String getBundleExternalKey() {
        return this.bundleExternalKey;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public LocalDate getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getEffectiveEndDate() {
        return this.effectiveEndDate;
    }

    public DateTime getEffectiveStartDate() {
        return this.effectiveStartDate;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public UUID getId() {
        return this.id;
    }

    public PlanPhase getLastActivePhase() {
        return this.lastActivePhase;
    }

    public Plan getLastActivePlan() {
        return this.lastActivePlan;
    }

    public PriceList getLastActivePriceList() {
        return this.lastActivePriceList;
    }

    public Product getLastActiveProduct() {
        return this.lastActiveProduct;
    }

    public ProductCategory getLastActiveProductCategory() {
        return this.lastActiveProductCategory;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Entitlement.EntitlementSourceType getSourceType() {
        return this.sourceType;
    }

    public Entitlement.EntitlementState getState() {
        return this.state;
    }

    public List<SubscriptionEvent> getSubscriptionEvents() {
        return this.subscriptionEvents;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public void uncancelEntitlement(Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("uncancelEntitlement(java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement changePlanOverrideBillingPolicy(EntitlementSpecifier spec, LocalDate effectiveDate, BillingActionPolicy billingPolicy, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("changePlanOverrideBillingPolicy(org.killbill.billing.entitlement.api.EntitlementSpecifier, org.joda.time.LocalDate, org.killbill.billing.catalog.api.BillingActionPolicy, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement changePlan(EntitlementSpecifier spec, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("changePlan(org.killbill.billing.entitlement.api.EntitlementSpecifier, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public void undoChangePlan(Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("undoChangePlan(java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement changePlanWithDate(EntitlementSpecifier spec, DateTime effectiveDate, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("changePlanWithDate(org.killbill.billing.entitlement.api.EntitlementSpecifier, org.joda.time.DateTime, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement cancelEntitlementWithDate(DateTime entitlementEffectiveDate, DateTime billingEffectiveDate, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("cancelEntitlementWithDate(org.joda.time.DateTime, org.joda.time.DateTime, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement cancelEntitlementWithPolicyOverrideBillingPolicy(Entitlement.EntitlementActionPolicy policy, BillingActionPolicy billingPolicy, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("cancelEntitlementWithPolicyOverrideBillingPolicy(org.killbill.billing.entitlement.api.Entitlement.EntitlementActionPolicy, org.killbill.billing.catalog.api.BillingActionPolicy, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement cancelEntitlementWithDate(LocalDate effectiveDate, boolean overrideBillingEffectiveDate, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("cancelEntitlementWithDate(org.joda.time.LocalDate, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement cancelEntitlementWithPolicy(Entitlement.EntitlementActionPolicy policy, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("cancelEntitlementWithPolicy(org.killbill.billing.entitlement.api.Entitlement.EntitlementActionPolicy, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement cancelEntitlementWithDateOverrideBillingPolicy(LocalDate effectiveDate, BillingActionPolicy billingPolicy, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("cancelEntitlementWithDateOverrideBillingPolicy(org.joda.time.LocalDate, org.killbill.billing.catalog.api.BillingActionPolicy, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public void updateBCD(int bcd, LocalDate effectiveFromDate, CallContext context) {
        throw new UnsupportedOperationException("updateBCD(int, org.joda.time.LocalDate, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public void updateQuantity(int quantity, LocalDate effectiveFromDate, CallContext context) {
        throw new UnsupportedOperationException("updateQuantity(int, org.joda.time.LocalDate, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Entitlement changePlanWithDate(EntitlementSpecifier spec, LocalDate effectiveDate, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("changePlanWithDate(org.killbill.billing.entitlement.api.EntitlementSpecifier, org.joda.time.LocalDate, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionImp that = (SubscriptionImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (!Objects.equals(this.baseEntitlementId, that.baseEntitlementId)) {
            return false;
        }
        if (!Objects.equals(this.billCycleDayLocal, that.billCycleDayLocal)) {
            return false;
        }
        if (this.billingEndDate != null ? 0 != this.billingEndDate.compareTo((ReadableInstant)that.billingEndDate) : that.billingEndDate != null) {
            return false;
        }
        if (this.billingStartDate != null ? 0 != this.billingStartDate.compareTo((ReadableInstant)that.billingStartDate) : that.billingStartDate != null) {
            return false;
        }
        if (!Objects.equals(this.bundleExternalKey, that.bundleExternalKey)) {
            return false;
        }
        if (!Objects.equals(this.bundleId, that.bundleId)) {
            return false;
        }
        if (!Objects.equals(this.chargedThroughDate, that.chargedThroughDate)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (this.effectiveEndDate != null ? 0 != this.effectiveEndDate.compareTo((ReadableInstant)that.effectiveEndDate) : that.effectiveEndDate != null) {
            return false;
        }
        if (this.effectiveStartDate != null ? 0 != this.effectiveStartDate.compareTo((ReadableInstant)that.effectiveStartDate) : that.effectiveStartDate != null) {
            return false;
        }
        if (!Objects.equals(this.externalKey, that.externalKey)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.lastActivePhase, that.lastActivePhase)) {
            return false;
        }
        if (!Objects.equals(this.lastActivePlan, that.lastActivePlan)) {
            return false;
        }
        if (!Objects.equals(this.lastActivePriceList, that.lastActivePriceList)) {
            return false;
        }
        if (!Objects.equals(this.lastActiveProduct, that.lastActiveProduct)) {
            return false;
        }
        if (!Objects.equals(this.lastActiveProductCategory, that.lastActiveProductCategory)) {
            return false;
        }
        if (!Objects.equals(this.quantity, that.quantity)) {
            return false;
        }
        if (!Objects.equals(this.sourceType, that.sourceType)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        if (!Objects.equals(this.subscriptionEvents, that.subscriptionEvents)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo((ReadableInstant)that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.baseEntitlementId);
        result = 31 * result + Objects.hashCode(this.billCycleDayLocal);
        result = 31 * result + Objects.hashCode(this.billingEndDate);
        result = 31 * result + Objects.hashCode(this.billingStartDate);
        result = 31 * result + Objects.hashCode(this.bundleExternalKey);
        result = 31 * result + Objects.hashCode(this.bundleId);
        result = 31 * result + Objects.hashCode(this.chargedThroughDate);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.effectiveEndDate);
        result = 31 * result + Objects.hashCode(this.effectiveStartDate);
        result = 31 * result + Objects.hashCode(this.externalKey);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.lastActivePhase);
        result = 31 * result + Objects.hashCode(this.lastActivePlan);
        result = 31 * result + Objects.hashCode(this.lastActivePriceList);
        result = 31 * result + Objects.hashCode(this.lastActiveProduct);
        result = 31 * result + Objects.hashCode(this.lastActiveProductCategory);
        result = 31 * result + Objects.hashCode(this.quantity);
        result = 31 * result + Objects.hashCode(this.sourceType);
        result = 31 * result + Objects.hashCode(this.state);
        result = 31 * result + Objects.hashCode(this.subscriptionEvents);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("baseEntitlementId=").append(this.baseEntitlementId);
        sb.append(", ");
        sb.append("billCycleDayLocal=").append(this.billCycleDayLocal);
        sb.append(", ");
        sb.append("billingEndDate=").append(this.billingEndDate);
        sb.append(", ");
        sb.append("billingStartDate=").append(this.billingStartDate);
        sb.append(", ");
        sb.append("bundleExternalKey=");
        if (this.bundleExternalKey == null) {
            sb.append(this.bundleExternalKey);
        } else {
            sb.append("'").append(this.bundleExternalKey).append("'");
        }
        sb.append(", ");
        sb.append("bundleId=").append(this.bundleId);
        sb.append(", ");
        sb.append("chargedThroughDate=").append(this.chargedThroughDate);
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("effectiveEndDate=").append(this.effectiveEndDate);
        sb.append(", ");
        sb.append("effectiveStartDate=").append(this.effectiveStartDate);
        sb.append(", ");
        sb.append("externalKey=");
        if (this.externalKey == null) {
            sb.append(this.externalKey);
        } else {
            sb.append("'").append(this.externalKey).append("'");
        }
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("lastActivePhase=").append(this.lastActivePhase);
        sb.append(", ");
        sb.append("lastActivePlan=").append(this.lastActivePlan);
        sb.append(", ");
        sb.append("lastActivePriceList=").append(this.lastActivePriceList);
        sb.append(", ");
        sb.append("lastActiveProduct=").append(this.lastActiveProduct);
        sb.append(", ");
        sb.append("lastActiveProductCategory=").append(this.lastActiveProductCategory);
        sb.append(", ");
        sb.append("quantity=").append(this.quantity);
        sb.append(", ");
        sb.append("sourceType=").append(this.sourceType);
        sb.append(", ");
        sb.append("state=").append(this.state);
        sb.append(", ");
        sb.append("subscriptionEvents=").append(this.subscriptionEvents);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected UUID baseEntitlementId;
        protected Integer billCycleDayLocal;
        protected DateTime billingEndDate;
        protected DateTime billingStartDate;
        protected String bundleExternalKey;
        protected UUID bundleId;
        protected LocalDate chargedThroughDate;
        protected DateTime createdDate;
        protected DateTime effectiveEndDate;
        protected DateTime effectiveStartDate;
        protected String externalKey;
        protected UUID id;
        protected PlanPhase lastActivePhase;
        protected Plan lastActivePlan;
        protected PriceList lastActivePriceList;
        protected Product lastActiveProduct;
        protected ProductCategory lastActiveProductCategory;
        protected Integer quantity;
        protected Entitlement.EntitlementSourceType sourceType;
        protected Entitlement.EntitlementState state;
        protected List<SubscriptionEvent> subscriptionEvents;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.baseEntitlementId = that.baseEntitlementId;
            this.billCycleDayLocal = that.billCycleDayLocal;
            this.billingEndDate = that.billingEndDate;
            this.billingStartDate = that.billingStartDate;
            this.bundleExternalKey = that.bundleExternalKey;
            this.bundleId = that.bundleId;
            this.chargedThroughDate = that.chargedThroughDate;
            this.createdDate = that.createdDate;
            this.effectiveEndDate = that.effectiveEndDate;
            this.effectiveStartDate = that.effectiveStartDate;
            this.externalKey = that.externalKey;
            this.id = that.id;
            this.lastActivePhase = that.lastActivePhase;
            this.lastActivePlan = that.lastActivePlan;
            this.lastActivePriceList = that.lastActivePriceList;
            this.lastActiveProduct = that.lastActiveProduct;
            this.lastActiveProductCategory = that.lastActiveProductCategory;
            this.quantity = that.quantity;
            this.sourceType = that.sourceType;
            this.state = that.state;
            this.subscriptionEvents = that.subscriptionEvents;
            this.updatedDate = that.updatedDate;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withBaseEntitlementId(UUID baseEntitlementId) {
            this.baseEntitlementId = baseEntitlementId;
            return (T)this;
        }

        public T withBillCycleDayLocal(Integer billCycleDayLocal) {
            this.billCycleDayLocal = billCycleDayLocal;
            return (T)this;
        }

        public T withBillingEndDate(DateTime billingEndDate) {
            this.billingEndDate = billingEndDate;
            return (T)this;
        }

        public T withBillingStartDate(DateTime billingStartDate) {
            this.billingStartDate = billingStartDate;
            return (T)this;
        }

        public T withBundleExternalKey(String bundleExternalKey) {
            this.bundleExternalKey = bundleExternalKey;
            return (T)this;
        }

        public T withBundleId(UUID bundleId) {
            this.bundleId = bundleId;
            return (T)this;
        }

        public T withChargedThroughDate(LocalDate chargedThroughDate) {
            this.chargedThroughDate = chargedThroughDate;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withEffectiveEndDate(DateTime effectiveEndDate) {
            this.effectiveEndDate = effectiveEndDate;
            return (T)this;
        }

        public T withEffectiveStartDate(DateTime effectiveStartDate) {
            this.effectiveStartDate = effectiveStartDate;
            return (T)this;
        }

        public T withExternalKey(String externalKey) {
            this.externalKey = externalKey;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withLastActivePhase(PlanPhase lastActivePhase) {
            this.lastActivePhase = lastActivePhase;
            return (T)this;
        }

        public T withLastActivePlan(Plan lastActivePlan) {
            this.lastActivePlan = lastActivePlan;
            return (T)this;
        }

        public T withLastActivePriceList(PriceList lastActivePriceList) {
            this.lastActivePriceList = lastActivePriceList;
            return (T)this;
        }

        public T withLastActiveProduct(Product lastActiveProduct) {
            this.lastActiveProduct = lastActiveProduct;
            return (T)this;
        }

        public T withLastActiveProductCategory(ProductCategory lastActiveProductCategory) {
            this.lastActiveProductCategory = lastActiveProductCategory;
            return (T)this;
        }

        public T withQuantity(Integer quantity) {
            this.quantity = quantity;
            return (T)this;
        }

        public T withSourceType(Entitlement.EntitlementSourceType sourceType) {
            this.sourceType = sourceType;
            return (T)this;
        }

        public T withState(Entitlement.EntitlementState state) {
            this.state = state;
            return (T)this;
        }

        public T withSubscriptionEvents(List<SubscriptionEvent> subscriptionEvents) {
            this.subscriptionEvents = subscriptionEvents;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(Subscription that) {
            this.accountId = that.getAccountId();
            this.baseEntitlementId = that.getBaseEntitlementId();
            this.billCycleDayLocal = that.getBillCycleDayLocal();
            this.billingEndDate = that.getBillingEndDate();
            this.billingStartDate = that.getBillingStartDate();
            this.bundleExternalKey = that.getBundleExternalKey();
            this.bundleId = that.getBundleId();
            this.chargedThroughDate = that.getChargedThroughDate();
            this.createdDate = that.getCreatedDate();
            this.effectiveEndDate = that.getEffectiveEndDate();
            this.effectiveStartDate = that.getEffectiveStartDate();
            this.externalKey = that.getExternalKey();
            this.id = that.getId();
            this.lastActivePhase = that.getLastActivePhase();
            this.lastActivePlan = that.getLastActivePlan();
            this.lastActivePriceList = that.getLastActivePriceList();
            this.lastActiveProduct = that.getLastActiveProduct();
            this.lastActiveProductCategory = that.getLastActiveProductCategory();
            this.quantity = that.getQuantity();
            this.sourceType = that.getSourceType();
            this.state = that.getState();
            this.subscriptionEvents = that.getSubscriptionEvents();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public SubscriptionImp build() {
            return new SubscriptionImp(this.validate());
        }
    }
}

