/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api.boilerplate;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;

@JsonDeserialize(builder=Builder.class)
public class BlockingStateImp
implements BlockingState {
    protected UUID blockedId;
    protected DateTime createdDate;
    protected String description;
    protected DateTime effectiveDate;
    protected UUID id;
    protected boolean isActive;
    protected boolean isBlockBilling;
    protected boolean isBlockChange;
    protected boolean isBlockEntitlement;
    protected String service;
    protected String stateName;
    protected BlockingStateType type;
    protected DateTime updatedDate;

    public BlockingStateImp(BlockingStateImp that) {
        this.blockedId = that.blockedId;
        this.createdDate = that.createdDate;
        this.description = that.description;
        this.effectiveDate = that.effectiveDate;
        this.id = that.id;
        this.isActive = that.isActive;
        this.isBlockBilling = that.isBlockBilling;
        this.isBlockChange = that.isBlockChange;
        this.isBlockEntitlement = that.isBlockEntitlement;
        this.service = that.service;
        this.stateName = that.stateName;
        this.type = that.type;
        this.updatedDate = that.updatedDate;
    }

    protected BlockingStateImp(Builder<?> builder) {
        this.blockedId = builder.blockedId;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.effectiveDate = builder.effectiveDate;
        this.id = builder.id;
        this.isActive = builder.isActive;
        this.isBlockBilling = builder.isBlockBilling;
        this.isBlockChange = builder.isBlockChange;
        this.isBlockEntitlement = builder.isBlockEntitlement;
        this.service = builder.service;
        this.stateName = builder.stateName;
        this.type = builder.type;
        this.updatedDate = builder.updatedDate;
    }

    protected BlockingStateImp() {
    }

    public UUID getBlockedId() {
        return this.blockedId;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public UUID getId() {
        return this.id;
    }

    @JsonGetter(value="isActive")
    public boolean isActive() {
        return this.isActive;
    }

    @JsonGetter(value="isBlockBilling")
    public boolean isBlockBilling() {
        return this.isBlockBilling;
    }

    @JsonGetter(value="isBlockChange")
    public boolean isBlockChange() {
        return this.isBlockChange;
    }

    @JsonGetter(value="isBlockEntitlement")
    public boolean isBlockEntitlement() {
        return this.isBlockEntitlement;
    }

    public String getService() {
        return this.service;
    }

    public String getStateName() {
        return this.stateName;
    }

    public BlockingStateType getType() {
        return this.type;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public int compareTo(BlockingState arg0) {
        throw new UnsupportedOperationException("compareTo(org.killbill.billing.entitlement.api.BlockingState) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockingStateImp that = (BlockingStateImp)o;
        if (!Objects.equals(this.blockedId, that.blockedId)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo((ReadableInstant)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (this.effectiveDate != null ? 0 != this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (this.isActive != that.isActive) {
            return false;
        }
        if (this.isBlockBilling != that.isBlockBilling) {
            return false;
        }
        if (this.isBlockChange != that.isBlockChange) {
            return false;
        }
        if (this.isBlockEntitlement != that.isBlockEntitlement) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        if (!Objects.equals(this.stateName, that.stateName)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo((ReadableInstant)that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.blockedId);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.effectiveDate);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.isActive);
        result = 31 * result + Objects.hashCode(this.isBlockBilling);
        result = 31 * result + Objects.hashCode(this.isBlockChange);
        result = 31 * result + Objects.hashCode(this.isBlockEntitlement);
        result = 31 * result + Objects.hashCode(this.service);
        result = 31 * result + Objects.hashCode(this.stateName);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("blockedId=").append(this.blockedId);
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("description=");
        if (this.description == null) {
            sb.append(this.description);
        } else {
            sb.append("'").append(this.description).append("'");
        }
        sb.append(", ");
        sb.append("effectiveDate=").append(this.effectiveDate);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("isActive=").append(this.isActive);
        sb.append(", ");
        sb.append("isBlockBilling=").append(this.isBlockBilling);
        sb.append(", ");
        sb.append("isBlockChange=").append(this.isBlockChange);
        sb.append(", ");
        sb.append("isBlockEntitlement=").append(this.isBlockEntitlement);
        sb.append(", ");
        sb.append("service=");
        if (this.service == null) {
            sb.append(this.service);
        } else {
            sb.append("'").append(this.service).append("'");
        }
        sb.append(", ");
        sb.append("stateName=");
        if (this.stateName == null) {
            sb.append(this.stateName);
        } else {
            sb.append("'").append(this.stateName).append("'");
        }
        sb.append(", ");
        sb.append("type=").append(this.type);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID blockedId;
        protected DateTime createdDate;
        protected String description;
        protected DateTime effectiveDate;
        protected UUID id;
        protected boolean isActive;
        protected boolean isBlockBilling;
        protected boolean isBlockChange;
        protected boolean isBlockEntitlement;
        protected String service;
        protected String stateName;
        protected BlockingStateType type;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.blockedId = that.blockedId;
            this.createdDate = that.createdDate;
            this.description = that.description;
            this.effectiveDate = that.effectiveDate;
            this.id = that.id;
            this.isActive = that.isActive;
            this.isBlockBilling = that.isBlockBilling;
            this.isBlockChange = that.isBlockChange;
            this.isBlockEntitlement = that.isBlockEntitlement;
            this.service = that.service;
            this.stateName = that.stateName;
            this.type = that.type;
            this.updatedDate = that.updatedDate;
        }

        public T withBlockedId(UUID blockedId) {
            this.blockedId = blockedId;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withDescription(String description) {
            this.description = description;
            return (T)this;
        }

        public T withEffectiveDate(DateTime effectiveDate) {
            this.effectiveDate = effectiveDate;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withIsActive(boolean isActive) {
            this.isActive = isActive;
            return (T)this;
        }

        public T withIsBlockBilling(boolean isBlockBilling) {
            this.isBlockBilling = isBlockBilling;
            return (T)this;
        }

        public T withIsBlockChange(boolean isBlockChange) {
            this.isBlockChange = isBlockChange;
            return (T)this;
        }

        public T withIsBlockEntitlement(boolean isBlockEntitlement) {
            this.isBlockEntitlement = isBlockEntitlement;
            return (T)this;
        }

        public T withService(String service) {
            this.service = service;
            return (T)this;
        }

        public T withStateName(String stateName) {
            this.stateName = stateName;
            return (T)this;
        }

        public T withType(BlockingStateType type) {
            this.type = type;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(BlockingState that) {
            this.blockedId = that.getBlockedId();
            this.createdDate = that.getCreatedDate();
            this.description = that.getDescription();
            this.effectiveDate = that.getEffectiveDate();
            this.id = that.getId();
            this.isActive = that.isActive();
            this.isBlockBilling = that.isBlockBilling();
            this.isBlockChange = that.isBlockChange();
            this.isBlockEntitlement = that.isBlockEntitlement();
            this.service = that.getService();
            this.stateName = that.getStateName();
            this.type = that.getType();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public BlockingStateImp build() {
            return new BlockingStateImp(this.validate());
        }
    }
}

