/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api.boilerplate;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.entitlement.api.BaseEntitlementWithAddOnsSpecifier;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;

@JsonDeserialize(builder=Builder.class)
public class BaseEntitlementWithAddOnsSpecifierImp
implements BaseEntitlementWithAddOnsSpecifier {
    protected DateTime billingEffectiveDate;
    protected String bundleExternalKey;
    protected UUID bundleId;
    protected DateTime entitlementEffectiveDate;
    protected Iterable<EntitlementSpecifier> entitlementSpecifier;
    protected boolean isMigrated;

    public BaseEntitlementWithAddOnsSpecifierImp(BaseEntitlementWithAddOnsSpecifierImp that) {
        this.billingEffectiveDate = that.billingEffectiveDate;
        this.bundleExternalKey = that.bundleExternalKey;
        this.bundleId = that.bundleId;
        this.entitlementEffectiveDate = that.entitlementEffectiveDate;
        this.entitlementSpecifier = that.entitlementSpecifier;
        this.isMigrated = that.isMigrated;
    }

    protected BaseEntitlementWithAddOnsSpecifierImp(Builder<?> builder) {
        this.billingEffectiveDate = builder.billingEffectiveDate;
        this.bundleExternalKey = builder.bundleExternalKey;
        this.bundleId = builder.bundleId;
        this.entitlementEffectiveDate = builder.entitlementEffectiveDate;
        this.entitlementSpecifier = builder.entitlementSpecifier;
        this.isMigrated = builder.isMigrated;
    }

    protected BaseEntitlementWithAddOnsSpecifierImp() {
    }

    public DateTime getBillingEffectiveDate() {
        return this.billingEffectiveDate;
    }

    public String getBundleExternalKey() {
        return this.bundleExternalKey;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public DateTime getEntitlementEffectiveDate() {
        return this.entitlementEffectiveDate;
    }

    public Iterable<EntitlementSpecifier> getEntitlementSpecifier() {
        return this.entitlementSpecifier;
    }

    @JsonGetter(value="isMigrated")
    public boolean isMigrated() {
        return this.isMigrated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntitlementWithAddOnsSpecifierImp that = (BaseEntitlementWithAddOnsSpecifierImp)o;
        if (this.billingEffectiveDate != null ? 0 != this.billingEffectiveDate.compareTo((ReadableInstant)that.billingEffectiveDate) : that.billingEffectiveDate != null) {
            return false;
        }
        if (!Objects.equals(this.bundleExternalKey, that.bundleExternalKey)) {
            return false;
        }
        if (!Objects.equals(this.bundleId, that.bundleId)) {
            return false;
        }
        if (this.entitlementEffectiveDate != null ? 0 != this.entitlementEffectiveDate.compareTo((ReadableInstant)that.entitlementEffectiveDate) : that.entitlementEffectiveDate != null) {
            return false;
        }
        if (!Objects.equals(this.entitlementSpecifier, that.entitlementSpecifier)) {
            return false;
        }
        return this.isMigrated == that.isMigrated;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.billingEffectiveDate);
        result = 31 * result + Objects.hashCode(this.bundleExternalKey);
        result = 31 * result + Objects.hashCode(this.bundleId);
        result = 31 * result + Objects.hashCode(this.entitlementEffectiveDate);
        result = 31 * result + Objects.hashCode(this.entitlementSpecifier);
        result = 31 * result + Objects.hashCode(this.isMigrated);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("billingEffectiveDate=").append(this.billingEffectiveDate);
        sb.append(", ");
        sb.append("bundleExternalKey=");
        if (this.bundleExternalKey == null) {
            sb.append(this.bundleExternalKey);
        } else {
            sb.append("'").append(this.bundleExternalKey).append("'");
        }
        sb.append(", ");
        sb.append("bundleId=").append(this.bundleId);
        sb.append(", ");
        sb.append("entitlementEffectiveDate=").append(this.entitlementEffectiveDate);
        sb.append(", ");
        sb.append("entitlementSpecifier=").append(this.entitlementSpecifier);
        sb.append(", ");
        sb.append("isMigrated=").append(this.isMigrated);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected DateTime billingEffectiveDate;
        protected String bundleExternalKey;
        protected UUID bundleId;
        protected DateTime entitlementEffectiveDate;
        protected Iterable<EntitlementSpecifier> entitlementSpecifier;
        protected boolean isMigrated;

        public Builder() {
        }

        public Builder(Builder that) {
            this.billingEffectiveDate = that.billingEffectiveDate;
            this.bundleExternalKey = that.bundleExternalKey;
            this.bundleId = that.bundleId;
            this.entitlementEffectiveDate = that.entitlementEffectiveDate;
            this.entitlementSpecifier = that.entitlementSpecifier;
            this.isMigrated = that.isMigrated;
        }

        public T withBillingEffectiveDate(DateTime billingEffectiveDate) {
            this.billingEffectiveDate = billingEffectiveDate;
            return (T)this;
        }

        public T withBundleExternalKey(String bundleExternalKey) {
            this.bundleExternalKey = bundleExternalKey;
            return (T)this;
        }

        public T withBundleId(UUID bundleId) {
            this.bundleId = bundleId;
            return (T)this;
        }

        public T withEntitlementEffectiveDate(DateTime entitlementEffectiveDate) {
            this.entitlementEffectiveDate = entitlementEffectiveDate;
            return (T)this;
        }

        public T withEntitlementSpecifier(Iterable<EntitlementSpecifier> entitlementSpecifier) {
            this.entitlementSpecifier = entitlementSpecifier;
            return (T)this;
        }

        public T withIsMigrated(boolean isMigrated) {
            this.isMigrated = isMigrated;
            return (T)this;
        }

        public T source(BaseEntitlementWithAddOnsSpecifier that) {
            this.billingEffectiveDate = that.getBillingEffectiveDate();
            this.bundleExternalKey = that.getBundleExternalKey();
            this.bundleId = that.getBundleId();
            this.entitlementEffectiveDate = that.getEntitlementEffectiveDate();
            this.entitlementSpecifier = that.getEntitlementSpecifier();
            this.isMigrated = that.isMigrated();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public BaseEntitlementWithAddOnsSpecifierImp build() {
            return new BaseEntitlementWithAddOnsSpecifierImp(this.validate());
        }
    }
}

