/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.currency.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.currency.api.Rate;

@JsonDeserialize(builder=Builder.class)
public class RateImp
implements Rate {
    protected Currency baseCurrency;
    protected DateTime conversionDate;
    protected Currency currency;
    protected BigDecimal value;

    public RateImp(RateImp that) {
        this.baseCurrency = that.baseCurrency;
        this.conversionDate = that.conversionDate;
        this.currency = that.currency;
        this.value = that.value;
    }

    protected RateImp(Builder<?> builder) {
        this.baseCurrency = builder.baseCurrency;
        this.conversionDate = builder.conversionDate;
        this.currency = builder.currency;
        this.value = builder.value;
    }

    protected RateImp() {
    }

    public Currency getBaseCurrency() {
        return this.baseCurrency;
    }

    public DateTime getConversionDate() {
        return this.conversionDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateImp that = (RateImp)o;
        if (!Objects.equals(this.baseCurrency, that.baseCurrency)) {
            return false;
        }
        if (this.conversionDate != null ? 0 != this.conversionDate.compareTo((ReadableInstant)that.conversionDate) : that.conversionDate != null) {
            return false;
        }
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.baseCurrency);
        result = 31 * result + Objects.hashCode(this.conversionDate);
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("baseCurrency=").append(this.baseCurrency);
        sb.append(", ");
        sb.append("conversionDate=").append(this.conversionDate);
        sb.append(", ");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("value=").append(this.value);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Currency baseCurrency;
        protected DateTime conversionDate;
        protected Currency currency;
        protected BigDecimal value;

        public Builder() {
        }

        public Builder(Builder that) {
            this.baseCurrency = that.baseCurrency;
            this.conversionDate = that.conversionDate;
            this.currency = that.currency;
            this.value = that.value;
        }

        public T withBaseCurrency(Currency baseCurrency) {
            this.baseCurrency = baseCurrency;
            return (T)this;
        }

        public T withConversionDate(DateTime conversionDate) {
            this.conversionDate = conversionDate;
            return (T)this;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withValue(BigDecimal value) {
            this.value = value;
            return (T)this;
        }

        public T source(Rate that) {
            this.baseCurrency = that.getBaseCurrency();
            this.conversionDate = that.getConversionDate();
            this.currency = that.getCurrency();
            this.value = that.getValue();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public RateImp build() {
            return new RateImp(this.validate());
        }
    }
}

