/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.control.plugin.api.boilerplate.plugin;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.control.plugin.api.PriorPaymentControlResult;
import org.killbill.billing.payment.api.PluginProperty;

@JsonDeserialize(builder=Builder.class)
public class PriorPaymentControlResultImp
implements PriorPaymentControlResult {
    protected BigDecimal adjustedAmount;
    protected Currency adjustedCurrency;
    protected UUID adjustedPaymentMethodId;
    protected String adjustedPluginName;
    protected Iterable<PluginProperty> adjustedPluginProperties;
    protected boolean isAborted;

    public PriorPaymentControlResultImp(PriorPaymentControlResultImp that) {
        this.adjustedAmount = that.adjustedAmount;
        this.adjustedCurrency = that.adjustedCurrency;
        this.adjustedPaymentMethodId = that.adjustedPaymentMethodId;
        this.adjustedPluginName = that.adjustedPluginName;
        this.adjustedPluginProperties = that.adjustedPluginProperties;
        this.isAborted = that.isAborted;
    }

    protected PriorPaymentControlResultImp(Builder<?> builder) {
        this.adjustedAmount = builder.adjustedAmount;
        this.adjustedCurrency = builder.adjustedCurrency;
        this.adjustedPaymentMethodId = builder.adjustedPaymentMethodId;
        this.adjustedPluginName = builder.adjustedPluginName;
        this.adjustedPluginProperties = builder.adjustedPluginProperties;
        this.isAborted = builder.isAborted;
    }

    protected PriorPaymentControlResultImp() {
    }

    public BigDecimal getAdjustedAmount() {
        return this.adjustedAmount;
    }

    public Currency getAdjustedCurrency() {
        return this.adjustedCurrency;
    }

    public UUID getAdjustedPaymentMethodId() {
        return this.adjustedPaymentMethodId;
    }

    public String getAdjustedPluginName() {
        return this.adjustedPluginName;
    }

    public Iterable<PluginProperty> getAdjustedPluginProperties() {
        return this.adjustedPluginProperties;
    }

    @JsonGetter(value="isAborted")
    public boolean isAborted() {
        return this.isAborted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriorPaymentControlResultImp that = (PriorPaymentControlResultImp)o;
        if (this.adjustedAmount != null ? 0 != this.adjustedAmount.compareTo(that.adjustedAmount) : that.adjustedAmount != null) {
            return false;
        }
        if (!Objects.equals(this.adjustedCurrency, that.adjustedCurrency)) {
            return false;
        }
        if (!Objects.equals(this.adjustedPaymentMethodId, that.adjustedPaymentMethodId)) {
            return false;
        }
        if (!Objects.equals(this.adjustedPluginName, that.adjustedPluginName)) {
            return false;
        }
        if (!Objects.equals(this.adjustedPluginProperties, that.adjustedPluginProperties)) {
            return false;
        }
        return this.isAborted == that.isAborted;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.adjustedAmount);
        result = 31 * result + Objects.hashCode(this.adjustedCurrency);
        result = 31 * result + Objects.hashCode(this.adjustedPaymentMethodId);
        result = 31 * result + Objects.hashCode(this.adjustedPluginName);
        result = 31 * result + Objects.hashCode(this.adjustedPluginProperties);
        result = 31 * result + Objects.hashCode(this.isAborted);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("adjustedAmount=").append(this.adjustedAmount);
        sb.append(", ");
        sb.append("adjustedCurrency=").append(this.adjustedCurrency);
        sb.append(", ");
        sb.append("adjustedPaymentMethodId=").append(this.adjustedPaymentMethodId);
        sb.append(", ");
        sb.append("adjustedPluginName=");
        if (this.adjustedPluginName == null) {
            sb.append(this.adjustedPluginName);
        } else {
            sb.append("'").append(this.adjustedPluginName).append("'");
        }
        sb.append(", ");
        sb.append("adjustedPluginProperties=").append(this.adjustedPluginProperties);
        sb.append(", ");
        sb.append("isAborted=").append(this.isAborted);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BigDecimal adjustedAmount;
        protected Currency adjustedCurrency;
        protected UUID adjustedPaymentMethodId;
        protected String adjustedPluginName;
        protected Iterable<PluginProperty> adjustedPluginProperties;
        protected boolean isAborted;

        public Builder() {
        }

        public Builder(Builder that) {
            this.adjustedAmount = that.adjustedAmount;
            this.adjustedCurrency = that.adjustedCurrency;
            this.adjustedPaymentMethodId = that.adjustedPaymentMethodId;
            this.adjustedPluginName = that.adjustedPluginName;
            this.adjustedPluginProperties = that.adjustedPluginProperties;
            this.isAborted = that.isAborted;
        }

        public T withAdjustedAmount(BigDecimal adjustedAmount) {
            this.adjustedAmount = adjustedAmount;
            return (T)this;
        }

        public T withAdjustedCurrency(Currency adjustedCurrency) {
            this.adjustedCurrency = adjustedCurrency;
            return (T)this;
        }

        public T withAdjustedPaymentMethodId(UUID adjustedPaymentMethodId) {
            this.adjustedPaymentMethodId = adjustedPaymentMethodId;
            return (T)this;
        }

        public T withAdjustedPluginName(String adjustedPluginName) {
            this.adjustedPluginName = adjustedPluginName;
            return (T)this;
        }

        public T withAdjustedPluginProperties(Iterable<PluginProperty> adjustedPluginProperties) {
            this.adjustedPluginProperties = adjustedPluginProperties;
            return (T)this;
        }

        public T withIsAborted(boolean isAborted) {
            this.isAborted = isAborted;
            return (T)this;
        }

        public T source(PriorPaymentControlResult that) {
            this.adjustedAmount = that.getAdjustedAmount();
            this.adjustedCurrency = that.getAdjustedCurrency();
            this.adjustedPaymentMethodId = that.getAdjustedPaymentMethodId();
            this.adjustedPluginName = that.getAdjustedPluginName();
            this.adjustedPluginProperties = that.getAdjustedPluginProperties();
            this.isAborted = that.isAborted();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PriorPaymentControlResultImp build() {
            return new PriorPaymentControlResultImp(this.validate());
        }
    }
}

