/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.rules.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.rules.CaseCreateAlignment;

@JsonDeserialize(builder=Builder.class)
public class CaseCreateAlignmentImp
implements CaseCreateAlignment {
    protected BillingPeriod billingPeriod;
    protected StaticCatalog catalog;
    protected PlanAlignmentCreate planAlignmentCreate;
    protected PriceList priceList;
    protected Product product;
    protected ProductCategory productCategory;

    public CaseCreateAlignmentImp(CaseCreateAlignmentImp that) {
        this.billingPeriod = that.billingPeriod;
        this.catalog = that.catalog;
        this.planAlignmentCreate = that.planAlignmentCreate;
        this.priceList = that.priceList;
        this.product = that.product;
        this.productCategory = that.productCategory;
    }

    protected CaseCreateAlignmentImp(Builder<?> builder) {
        this.billingPeriod = builder.billingPeriod;
        this.catalog = builder.catalog;
        this.planAlignmentCreate = builder.planAlignmentCreate;
        this.priceList = builder.priceList;
        this.product = builder.product;
        this.productCategory = builder.productCategory;
    }

    protected CaseCreateAlignmentImp() {
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public StaticCatalog getCatalog() {
        return this.catalog;
    }

    public PlanAlignmentCreate getPlanAlignmentCreate() {
        return this.planAlignmentCreate;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public Product getProduct() {
        return this.product;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseCreateAlignmentImp that = (CaseCreateAlignmentImp)o;
        if (!Objects.equals(this.billingPeriod, that.billingPeriod)) {
            return false;
        }
        if (!Objects.equals(this.catalog, that.catalog)) {
            return false;
        }
        if (!Objects.equals(this.planAlignmentCreate, that.planAlignmentCreate)) {
            return false;
        }
        if (!Objects.equals(this.priceList, that.priceList)) {
            return false;
        }
        if (!Objects.equals(this.product, that.product)) {
            return false;
        }
        return Objects.equals(this.productCategory, that.productCategory);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.billingPeriod);
        result = 31 * result + Objects.hashCode(this.catalog);
        result = 31 * result + Objects.hashCode(this.planAlignmentCreate);
        result = 31 * result + Objects.hashCode(this.priceList);
        result = 31 * result + Objects.hashCode(this.product);
        result = 31 * result + Objects.hashCode(this.productCategory);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("billingPeriod=").append(this.billingPeriod);
        sb.append(", ");
        sb.append("catalog=").append(this.catalog);
        sb.append(", ");
        sb.append("planAlignmentCreate=").append(this.planAlignmentCreate);
        sb.append(", ");
        sb.append("priceList=").append(this.priceList);
        sb.append(", ");
        sb.append("product=").append(this.product);
        sb.append(", ");
        sb.append("productCategory=").append(this.productCategory);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BillingPeriod billingPeriod;
        protected StaticCatalog catalog;
        protected PlanAlignmentCreate planAlignmentCreate;
        protected PriceList priceList;
        protected Product product;
        protected ProductCategory productCategory;

        public Builder() {
        }

        public Builder(Builder that) {
            this.billingPeriod = that.billingPeriod;
            this.catalog = that.catalog;
            this.planAlignmentCreate = that.planAlignmentCreate;
            this.priceList = that.priceList;
            this.product = that.product;
            this.productCategory = that.productCategory;
        }

        public T withBillingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return (T)this;
        }

        public T withCatalog(StaticCatalog catalog) {
            this.catalog = catalog;
            return (T)this;
        }

        public T withPlanAlignmentCreate(PlanAlignmentCreate planAlignmentCreate) {
            this.planAlignmentCreate = planAlignmentCreate;
            return (T)this;
        }

        public T withPriceList(PriceList priceList) {
            this.priceList = priceList;
            return (T)this;
        }

        public T withProduct(Product product) {
            this.product = product;
            return (T)this;
        }

        public T withProductCategory(ProductCategory productCategory) {
            this.productCategory = productCategory;
            return (T)this;
        }

        public T source(CaseCreateAlignment that) {
            this.billingPeriod = that.getBillingPeriod();
            this.catalog = that.getCatalog();
            this.planAlignmentCreate = that.getPlanAlignmentCreate();
            this.priceList = that.getPriceList();
            this.product = that.getProduct();
            this.productCategory = that.getProductCategory();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public CaseCreateAlignmentImp build() {
            return new CaseCreateAlignmentImp(this.validate());
        }
    }
}

