/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.VersionedCatalog;

@JsonDeserialize(builder=Builder.class)
public class VersionedCatalogImp
implements VersionedCatalog {
    protected String catalogName;
    protected StaticCatalog currentVersion;
    protected List<StaticCatalog> versions;

    public VersionedCatalogImp(VersionedCatalogImp that) {
        this.catalogName = that.catalogName;
        this.currentVersion = that.currentVersion;
        this.versions = that.versions;
    }

    protected VersionedCatalogImp(Builder<?> builder) {
        this.catalogName = builder.catalogName;
        this.currentVersion = builder.currentVersion;
        this.versions = builder.versions;
    }

    protected VersionedCatalogImp() {
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public StaticCatalog getCurrentVersion() {
        return this.currentVersion;
    }

    public List<StaticCatalog> getVersions() {
        return this.versions;
    }

    public StaticCatalog getVersion(Date targetDate) {
        throw new UnsupportedOperationException("getVersion(java.util.Date) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedCatalogImp that = (VersionedCatalogImp)o;
        if (!Objects.equals(this.catalogName, that.catalogName)) {
            return false;
        }
        if (!Objects.equals(this.currentVersion, that.currentVersion)) {
            return false;
        }
        return Objects.equals(this.versions, that.versions);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.catalogName);
        result = 31 * result + Objects.hashCode(this.currentVersion);
        result = 31 * result + Objects.hashCode(this.versions);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("catalogName=");
        if (this.catalogName == null) {
            sb.append(this.catalogName);
        } else {
            sb.append("'").append(this.catalogName).append("'");
        }
        sb.append(", ");
        sb.append("currentVersion=").append(this.currentVersion);
        sb.append(", ");
        sb.append("versions=").append(this.versions);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String catalogName;
        protected StaticCatalog currentVersion;
        protected List<StaticCatalog> versions;

        public Builder() {
        }

        public Builder(Builder that) {
            this.catalogName = that.catalogName;
            this.currentVersion = that.currentVersion;
            this.versions = that.versions;
        }

        public T withCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return (T)this;
        }

        public T withCurrentVersion(StaticCatalog currentVersion) {
            this.currentVersion = currentVersion;
            return (T)this;
        }

        public T withVersions(List<StaticCatalog> versions) {
            this.versions = versions;
            return (T)this;
        }

        public T source(VersionedCatalog that) {
            this.catalogName = that.getCatalogName();
            this.currentVersion = that.getCurrentVersion();
            this.versions = that.getVersions();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public VersionedCatalogImp build() {
            return new VersionedCatalogImp(this.validate());
        }
    }
}

