/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;

@JsonDeserialize(builder=Builder.class)
public class TieredBlockPriceOverrideImp
implements TieredBlockPriceOverride {
    protected Currency currency;
    protected BigDecimal max;
    protected BigDecimal price;
    protected BigDecimal size;
    protected String unitName;

    public TieredBlockPriceOverrideImp(TieredBlockPriceOverrideImp that) {
        this.currency = that.currency;
        this.max = that.max;
        this.price = that.price;
        this.size = that.size;
        this.unitName = that.unitName;
    }

    protected TieredBlockPriceOverrideImp(Builder<?> builder) {
        this.currency = builder.currency;
        this.max = builder.max;
        this.price = builder.price;
        this.size = builder.size;
        this.unitName = builder.unitName;
    }

    protected TieredBlockPriceOverrideImp() {
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TieredBlockPriceOverrideImp that = (TieredBlockPriceOverrideImp)o;
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        if (!Objects.equals(this.max, that.max)) {
            return false;
        }
        if (!Objects.equals(this.price, that.price)) {
            return false;
        }
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        return Objects.equals(this.unitName, that.unitName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.max);
        result = 31 * result + Objects.hashCode(this.price);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.unitName);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("max=").append(this.max);
        sb.append(", ");
        sb.append("price=").append(this.price);
        sb.append(", ");
        sb.append("size=").append(this.size);
        sb.append(", ");
        sb.append("unitName=");
        if (this.unitName == null) {
            sb.append(this.unitName);
        } else {
            sb.append("'").append(this.unitName).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Currency currency;
        protected BigDecimal max;
        protected BigDecimal price;
        protected BigDecimal size;
        protected String unitName;

        public Builder() {
        }

        public Builder(Builder that) {
            this.currency = that.currency;
            this.max = that.max;
            this.price = that.price;
            this.size = that.size;
            this.unitName = that.unitName;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withMax(BigDecimal max) {
            this.max = max;
            return (T)this;
        }

        public T withPrice(BigDecimal price) {
            this.price = price;
            return (T)this;
        }

        public T withSize(BigDecimal size) {
            this.size = size;
            return (T)this;
        }

        public T withUnitName(String unitName) {
            this.unitName = unitName;
            return (T)this;
        }

        public T source(TieredBlockPriceOverride that) {
            this.currency = that.getCurrency();
            this.max = that.getMax();
            this.price = that.getPrice();
            this.size = that.getSize();
            this.unitName = that.getUnitName();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TieredBlockPriceOverrideImp build() {
            return new TieredBlockPriceOverrideImp(this.validate());
        }
    }
}

