/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Objects;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TieredBlock;

@JsonDeserialize(builder=Builder.class)
public class TierImp
implements Tier {
    protected InternationalPrice fixedPrice;
    protected Limit[] limits;
    protected InternationalPrice recurringPrice;
    protected TieredBlock[] tieredBlocks;

    public TierImp(TierImp that) {
        this.fixedPrice = that.fixedPrice;
        this.limits = that.limits;
        this.recurringPrice = that.recurringPrice;
        this.tieredBlocks = that.tieredBlocks;
    }

    protected TierImp(Builder<?> builder) {
        this.fixedPrice = builder.fixedPrice;
        this.limits = builder.limits;
        this.recurringPrice = builder.recurringPrice;
        this.tieredBlocks = builder.tieredBlocks;
    }

    protected TierImp() {
    }

    public InternationalPrice getFixedPrice() {
        return this.fixedPrice;
    }

    public Limit[] getLimits() {
        return this.limits;
    }

    public InternationalPrice getRecurringPrice() {
        return this.recurringPrice;
    }

    public TieredBlock[] getTieredBlocks() {
        return this.tieredBlocks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierImp that = (TierImp)o;
        if (!Objects.equals(this.fixedPrice, that.fixedPrice)) {
            return false;
        }
        if (!Arrays.deepEquals(this.limits, that.limits)) {
            return false;
        }
        if (!Objects.equals(this.recurringPrice, that.recurringPrice)) {
            return false;
        }
        return Arrays.deepEquals(this.tieredBlocks, that.tieredBlocks);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.fixedPrice);
        result = 31 * result + Arrays.deepHashCode(this.limits);
        result = 31 * result + Objects.hashCode(this.recurringPrice);
        result = 31 * result + Arrays.deepHashCode(this.tieredBlocks);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("fixedPrice=").append(this.fixedPrice);
        sb.append(", ");
        sb.append("limits=").append(Arrays.toString(this.limits));
        sb.append(", ");
        sb.append("recurringPrice=").append(this.recurringPrice);
        sb.append(", ");
        sb.append("tieredBlocks=").append(Arrays.toString(this.tieredBlocks));
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected InternationalPrice fixedPrice;
        protected Limit[] limits;
        protected InternationalPrice recurringPrice;
        protected TieredBlock[] tieredBlocks;

        public Builder() {
        }

        public Builder(Builder that) {
            this.fixedPrice = that.fixedPrice;
            this.limits = that.limits;
            this.recurringPrice = that.recurringPrice;
            this.tieredBlocks = that.tieredBlocks;
        }

        public T withFixedPrice(InternationalPrice fixedPrice) {
            this.fixedPrice = fixedPrice;
            return (T)this;
        }

        public T withLimits(Limit[] limits) {
            this.limits = limits;
            return (T)this;
        }

        public T withRecurringPrice(InternationalPrice recurringPrice) {
            this.recurringPrice = recurringPrice;
            return (T)this;
        }

        public T withTieredBlocks(TieredBlock[] tieredBlocks) {
            this.tieredBlocks = tieredBlocks;
            return (T)this;
        }

        public T source(Tier that) {
            this.fixedPrice = that.getFixedPrice();
            this.limits = that.getLimits();
            this.recurringPrice = that.getRecurringPrice();
            this.tieredBlocks = that.getTieredBlocks();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TierImp build() {
            return new TierImp(this.validate());
        }
    }
}

