/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Recurring;

@JsonDeserialize(builder=Builder.class)
public class RecurringImp
implements Recurring {
    protected BillingPeriod billingPeriod;
    protected InternationalPrice recurringPrice;

    public RecurringImp(RecurringImp that) {
        this.billingPeriod = that.billingPeriod;
        this.recurringPrice = that.recurringPrice;
    }

    protected RecurringImp(Builder<?> builder) {
        this.billingPeriod = builder.billingPeriod;
        this.recurringPrice = builder.recurringPrice;
    }

    protected RecurringImp() {
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public InternationalPrice getRecurringPrice() {
        return this.recurringPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringImp that = (RecurringImp)o;
        if (!Objects.equals(this.billingPeriod, that.billingPeriod)) {
            return false;
        }
        return Objects.equals(this.recurringPrice, that.recurringPrice);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.billingPeriod);
        result = 31 * result + Objects.hashCode(this.recurringPrice);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("billingPeriod=").append(this.billingPeriod);
        sb.append(", ");
        sb.append("recurringPrice=").append(this.recurringPrice);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BillingPeriod billingPeriod;
        protected InternationalPrice recurringPrice;

        public Builder() {
        }

        public Builder(Builder that) {
            this.billingPeriod = that.billingPeriod;
            this.recurringPrice = that.recurringPrice;
        }

        public T withBillingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return (T)this;
        }

        public T withRecurringPrice(InternationalPrice recurringPrice) {
            this.recurringPrice = recurringPrice;
            return (T)this;
        }

        public T source(Recurring that) {
            this.billingPeriod = that.getBillingPeriod();
            this.recurringPrice = that.getRecurringPrice();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public RecurringImp build() {
            return new RecurringImp(this.validate());
        }
    }
}

