/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collection;
import java.util.Objects;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.StaticCatalog;

@JsonDeserialize(builder=Builder.class)
public class PriceListImp
implements PriceList {
    protected StaticCatalog catalog;
    protected String name;
    protected Collection<Plan> plans;
    protected String prettyName;

    public PriceListImp(PriceListImp that) {
        this.catalog = that.catalog;
        this.name = that.name;
        this.plans = that.plans;
        this.prettyName = that.prettyName;
    }

    protected PriceListImp(Builder<?> builder) {
        this.catalog = builder.catalog;
        this.name = builder.name;
        this.plans = builder.plans;
        this.prettyName = builder.prettyName;
    }

    protected PriceListImp() {
    }

    public StaticCatalog getCatalog() {
        return this.catalog;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Plan> getPlans() {
        return this.plans;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public Collection<Plan> findPlans(Product product, BillingPeriod period) {
        throw new UnsupportedOperationException("findPlans(org.killbill.billing.catalog.api.Product, org.killbill.billing.catalog.api.BillingPeriod) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceListImp that = (PriceListImp)o;
        if (!Objects.equals(this.catalog, that.catalog)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.plans, that.plans)) {
            return false;
        }
        return Objects.equals(this.prettyName, that.prettyName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.catalog);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.plans);
        result = 31 * result + Objects.hashCode(this.prettyName);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("catalog=").append(this.catalog);
        sb.append(", ");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("plans=").append(this.plans);
        sb.append(", ");
        sb.append("prettyName=");
        if (this.prettyName == null) {
            sb.append(this.prettyName);
        } else {
            sb.append("'").append(this.prettyName).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected StaticCatalog catalog;
        protected String name;
        protected Collection<Plan> plans;
        protected String prettyName;

        public Builder() {
        }

        public Builder(Builder that) {
            this.catalog = that.catalog;
            this.name = that.name;
            this.plans = that.plans;
            this.prettyName = that.prettyName;
        }

        public T withCatalog(StaticCatalog catalog) {
            this.catalog = catalog;
            return (T)this;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withPlans(Collection<Plan> plans) {
            this.plans = plans;
            return (T)this;
        }

        public T withPrettyName(String prettyName) {
            this.prettyName = prettyName;
            return (T)this;
        }

        public T source(PriceList that) {
            this.catalog = that.getCatalog();
            this.name = that.getName();
            this.plans = that.getPlans();
            this.prettyName = that.getPrettyName();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PriceListImp build() {
            return new PriceListImp(this.validate());
        }
    }
}

