/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.MutableStaticCatalog;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.PriceListSet;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.billing.catalog.api.rules.PlanRules;

@JsonDeserialize(builder=Builder.class)
public class MutableStaticCatalogImp
implements MutableStaticCatalog {
    protected List<Listing> availableBasePlanListings;
    protected String catalogName;
    protected Date effectiveDate;
    protected PlanRules planRules;
    protected Collection<Plan> plans;
    protected PriceListSet priceLists;
    protected Collection<Product> products;
    protected Currency[] supportedCurrencies;
    protected Unit[] units;

    public MutableStaticCatalogImp(MutableStaticCatalogImp that) {
        this.availableBasePlanListings = that.availableBasePlanListings;
        this.catalogName = that.catalogName;
        this.effectiveDate = that.effectiveDate;
        this.planRules = that.planRules;
        this.plans = that.plans;
        this.priceLists = that.priceLists;
        this.products = that.products;
        this.supportedCurrencies = that.supportedCurrencies;
        this.units = that.units;
    }

    protected MutableStaticCatalogImp(Builder<?> builder) {
        this.availableBasePlanListings = builder.availableBasePlanListings;
        this.catalogName = builder.catalogName;
        this.effectiveDate = builder.effectiveDate;
        this.planRules = builder.planRules;
        this.plans = builder.plans;
        this.priceLists = builder.priceLists;
        this.products = builder.products;
        this.supportedCurrencies = builder.supportedCurrencies;
        this.units = builder.units;
    }

    protected MutableStaticCatalogImp() {
    }

    public List<Listing> getAvailableBasePlanListings() {
        return this.availableBasePlanListings;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public PlanRules getPlanRules() {
        return this.planRules;
    }

    public Collection<Plan> getPlans() {
        return this.plans;
    }

    public PriceListSet getPriceLists() {
        return this.priceLists;
    }

    public Collection<Product> getProducts() {
        return this.products;
    }

    public Currency[] getSupportedCurrencies() {
        return this.supportedCurrencies;
    }

    public Unit[] getUnits() {
        return this.units;
    }

    public Plan createOrFindPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides) {
        throw new UnsupportedOperationException("createOrFindPlan(org.killbill.billing.catalog.api.PlanSpecifier, org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext) must be implemented.");
    }

    public Plan findPlan(String name) {
        throw new UnsupportedOperationException("findPlan(java.lang.String) must be implemented.");
    }

    public void addProduct(Product product) {
        throw new UnsupportedOperationException("addProduct(org.killbill.billing.catalog.api.Product) must be implemented.");
    }

    public List<Listing> getAvailableAddOnListings(String baseProductName, String priceListName) {
        throw new UnsupportedOperationException("getAvailableAddOnListings(java.lang.String, java.lang.String) must be implemented.");
    }

    public void addPlan(Plan plan) {
        throw new UnsupportedOperationException("addPlan(org.killbill.billing.catalog.api.Plan) must be implemented.");
    }

    public Product findProduct(String name) {
        throw new UnsupportedOperationException("findProduct(java.lang.String) must be implemented.");
    }

    public PlanPhase findPhase(String name) {
        throw new UnsupportedOperationException("findPhase(java.lang.String) must be implemented.");
    }

    public void addCurrency(Currency currency) {
        throw new UnsupportedOperationException("addCurrency(org.killbill.billing.catalog.api.Currency) must be implemented.");
    }

    public PriceList findPriceList(String name) {
        throw new UnsupportedOperationException("findPriceList(java.lang.String) must be implemented.");
    }

    public void addPriceList(PriceList priceList) {
        throw new UnsupportedOperationException("addPriceList(org.killbill.billing.catalog.api.PriceList) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableStaticCatalogImp that = (MutableStaticCatalogImp)o;
        if (!Objects.equals(this.availableBasePlanListings, that.availableBasePlanListings)) {
            return false;
        }
        if (!Objects.equals(this.catalogName, that.catalogName)) {
            return false;
        }
        if (!Objects.equals(this.effectiveDate, that.effectiveDate)) {
            return false;
        }
        if (!Objects.equals(this.planRules, that.planRules)) {
            return false;
        }
        if (!Objects.equals(this.plans, that.plans)) {
            return false;
        }
        if (!Objects.equals(this.priceLists, that.priceLists)) {
            return false;
        }
        if (!Objects.equals(this.products, that.products)) {
            return false;
        }
        if (!Arrays.deepEquals(this.supportedCurrencies, that.supportedCurrencies)) {
            return false;
        }
        return Arrays.deepEquals(this.units, that.units);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.availableBasePlanListings);
        result = 31 * result + Objects.hashCode(this.catalogName);
        result = 31 * result + Objects.hashCode(this.effectiveDate);
        result = 31 * result + Objects.hashCode(this.planRules);
        result = 31 * result + Objects.hashCode(this.plans);
        result = 31 * result + Objects.hashCode(this.priceLists);
        result = 31 * result + Objects.hashCode(this.products);
        result = 31 * result + Arrays.deepHashCode(this.supportedCurrencies);
        result = 31 * result + Arrays.deepHashCode(this.units);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("availableBasePlanListings=").append(this.availableBasePlanListings);
        sb.append(", ");
        sb.append("catalogName=");
        if (this.catalogName == null) {
            sb.append(this.catalogName);
        } else {
            sb.append("'").append(this.catalogName).append("'");
        }
        sb.append(", ");
        sb.append("effectiveDate=").append(this.effectiveDate);
        sb.append(", ");
        sb.append("planRules=").append(this.planRules);
        sb.append(", ");
        sb.append("plans=").append(this.plans);
        sb.append(", ");
        sb.append("priceLists=").append(this.priceLists);
        sb.append(", ");
        sb.append("products=").append(this.products);
        sb.append(", ");
        sb.append("supportedCurrencies=").append(Arrays.toString(this.supportedCurrencies));
        sb.append(", ");
        sb.append("units=").append(Arrays.toString(this.units));
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected List<Listing> availableBasePlanListings;
        protected String catalogName;
        protected Date effectiveDate;
        protected PlanRules planRules;
        protected Collection<Plan> plans;
        protected PriceListSet priceLists;
        protected Collection<Product> products;
        protected Currency[] supportedCurrencies;
        protected Unit[] units;

        public Builder() {
        }

        public Builder(Builder that) {
            this.availableBasePlanListings = that.availableBasePlanListings;
            this.catalogName = that.catalogName;
            this.effectiveDate = that.effectiveDate;
            this.planRules = that.planRules;
            this.plans = that.plans;
            this.priceLists = that.priceLists;
            this.products = that.products;
            this.supportedCurrencies = that.supportedCurrencies;
            this.units = that.units;
        }

        public T withAvailableBasePlanListings(List<Listing> availableBasePlanListings) {
            this.availableBasePlanListings = availableBasePlanListings;
            return (T)this;
        }

        public T withCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return (T)this;
        }

        public T withEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate;
            return (T)this;
        }

        public T withPlanRules(PlanRules planRules) {
            this.planRules = planRules;
            return (T)this;
        }

        public T withPlans(Collection<Plan> plans) {
            this.plans = plans;
            return (T)this;
        }

        public T withPriceLists(PriceListSet priceLists) {
            this.priceLists = priceLists;
            return (T)this;
        }

        public T withProducts(Collection<Product> products) {
            this.products = products;
            return (T)this;
        }

        public T withSupportedCurrencies(Currency[] supportedCurrencies) {
            this.supportedCurrencies = supportedCurrencies;
            return (T)this;
        }

        public T withUnits(Unit[] units) {
            this.units = units;
            return (T)this;
        }

        public T source(MutableStaticCatalog that) throws CatalogApiException {
            this.availableBasePlanListings = that.getAvailableBasePlanListings();
            this.catalogName = that.getCatalogName();
            this.effectiveDate = that.getEffectiveDate();
            this.planRules = that.getPlanRules();
            this.plans = that.getPlans();
            this.priceLists = that.getPriceLists();
            this.products = that.getProducts();
            this.supportedCurrencies = that.getSupportedCurrencies();
            this.units = that.getUnits();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public MutableStaticCatalogImp build() {
            return new MutableStaticCatalogImp(this.validate());
        }
    }
}

