/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PriceList;

@JsonDeserialize(builder=Builder.class)
public class ListingImp
implements Listing {
    protected Plan plan;
    protected PriceList priceList;

    public ListingImp(ListingImp that) {
        this.plan = that.plan;
        this.priceList = that.priceList;
    }

    protected ListingImp(Builder<?> builder) {
        this.plan = builder.plan;
        this.priceList = builder.priceList;
    }

    protected ListingImp() {
    }

    public Plan getPlan() {
        return this.plan;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListingImp that = (ListingImp)o;
        if (!Objects.equals(this.plan, that.plan)) {
            return false;
        }
        return Objects.equals(this.priceList, that.priceList);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.plan);
        result = 31 * result + Objects.hashCode(this.priceList);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("plan=").append(this.plan);
        sb.append(", ");
        sb.append("priceList=").append(this.priceList);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Plan plan;
        protected PriceList priceList;

        public Builder() {
        }

        public Builder(Builder that) {
            this.plan = that.plan;
            this.priceList = that.priceList;
        }

        public T withPlan(Plan plan) {
            this.plan = plan;
            return (T)this;
        }

        public T withPriceList(PriceList priceList) {
            this.priceList = priceList;
            return (T)this;
        }

        public T source(Listing that) {
            this.plan = that.getPlan();
            this.priceList = that.getPriceList();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public ListingImp build() {
            return new ListingImp(this.validate());
        }
    }
}

