/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.catalog.api.Fixed;
import org.killbill.billing.catalog.api.FixedType;
import org.killbill.billing.catalog.api.InternationalPrice;

@JsonDeserialize(builder=Builder.class)
public class FixedImp
implements Fixed {
    protected InternationalPrice price;
    protected FixedType type;

    public FixedImp(FixedImp that) {
        this.price = that.price;
        this.type = that.type;
    }

    protected FixedImp(Builder<?> builder) {
        this.price = builder.price;
        this.type = builder.type;
    }

    protected FixedImp() {
    }

    public InternationalPrice getPrice() {
        return this.price;
    }

    public FixedType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedImp that = (FixedImp)o;
        if (!Objects.equals(this.price, that.price)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.price);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("price=").append(this.price);
        sb.append(", ");
        sb.append("type=").append(this.type);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected InternationalPrice price;
        protected FixedType type;

        public Builder() {
        }

        public Builder(Builder that) {
            this.price = that.price;
            this.type = that.type;
        }

        public T withPrice(InternationalPrice price) {
            this.price = price;
            return (T)this;
        }

        public T withType(FixedType type) {
            this.type = type;
            return (T)this;
        }

        public T source(Fixed that) {
            this.price = that.getPrice();
            this.type = that.getType();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public FixedImp build() {
            return new FixedImp(this.validate());
        }
    }
}

