/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.TimeUnit;

@JsonDeserialize(builder=Builder.class)
public class DurationImp
implements Duration {
    protected int number;
    protected TimeUnit unit;

    public DurationImp(DurationImp that) {
        this.number = that.number;
        this.unit = that.unit;
    }

    protected DurationImp(Builder<?> builder) {
        this.number = builder.number;
        this.unit = builder.unit;
    }

    protected DurationImp() {
    }

    public int getNumber() {
        return this.number;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public LocalDate addToLocalDate(LocalDate localDate) {
        throw new UnsupportedOperationException("addToLocalDate(org.joda.time.LocalDate) must be implemented.");
    }

    public Period toJodaPeriod() {
        throw new UnsupportedOperationException("toJodaPeriod() must be implemented.");
    }

    public DateTime addToDateTime(DateTime dateTime) {
        throw new UnsupportedOperationException("addToDateTime(org.joda.time.DateTime) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationImp that = (DurationImp)o;
        if (this.number != that.number) {
            return false;
        }
        return Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.number);
        result = 31 * result + Objects.hashCode(this.unit);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("number=").append(this.number);
        sb.append(", ");
        sb.append("unit=").append(this.unit);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected int number;
        protected TimeUnit unit;

        public Builder() {
        }

        public Builder(Builder that) {
            this.number = that.number;
            this.unit = that.unit;
        }

        public T withNumber(int number) {
            this.number = number;
            return (T)this;
        }

        public T withUnit(TimeUnit unit) {
            this.unit = unit;
            return (T)this;
        }

        public T source(Duration that) {
            this.number = that.getNumber();
            this.unit = that.getUnit();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public DurationImp build() {
            return new DurationImp(this.validate());
        }
    }
}

