/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class WidthBucket<T extends Number>
extends AbstractField<T> {
    private final Field<T> field;
    private final Field<T> low;
    private final Field<T> high;
    private final Field<Integer> buckets;

    WidthBucket(Field<T> field, Field<T> low, Field<T> high, Field<Integer> buckets) {
        super(Names.N_WIDTH_BUCKET, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, field, false), field, low, high, buckets));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.INTEGER);
        this.low = Tools.nullSafeNotNull(low, SQLDataType.INTEGER);
        this.high = Tools.nullSafeNotNull(high, SQLDataType.INTEGER);
        this.buckets = Tools.nullSafeNotNull(buckets, SQLDataType.INTEGER);
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.visit(DSL.keyword("width_bucket")).sql('(').visit(this.field).sql(", ").visit(this.low).sql(", ").visit(this.high).sql(", ").visit(this.buckets).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.when(this.field.lt(this.low), DSL.zero()).when(this.field.ge(this.high), Internal.iadd(this.buckets, DSL.one())).otherwise(Internal.iadd(DSL.floor(Internal.idiv(Internal.imul(Internal.isub(this.field, this.low), this.buckets), Internal.isub(this.high, this.low))), DSL.one())));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof WidthBucket) {
            return StringUtils.equals(this.field, ((WidthBucket)that).field) && StringUtils.equals(this.low, ((WidthBucket)that).low) && StringUtils.equals(this.high, ((WidthBucket)that).high) && StringUtils.equals(this.buckets, ((WidthBucket)that).buckets);
        }
        return super.equals(that);
    }
}

