/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Context;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;

final class TableComparison<R extends Record>
extends AbstractCondition {
    private final Table<R> lhs;
    private final Table<R> rhs;
    private final Comparator comparator;

    TableComparison(Table<R> lhs, Table<R> rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.sql('(').visit(this.lhs).sql(' ').sql(this.comparator.toSQL()).sql(' ').visit(this.rhs).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.row(this.lhs.fields()).compare(this.comparator, DSL.row(this.rhs.fields())));
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

