/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Square<T extends Number>
extends AbstractField<T> {
    private final Field<T> value;

    Square(Field<T> value) {
        super(Names.N_SQUARE, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                ctx.visit(Internal.imul(this.value, this.value));
                break;
            }
            case CUBRID: 
            case DERBY: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: {
                if (Tools.isSimple(this.value)) {
                    ctx.visit(Internal.imul(this.value, this.value));
                    break;
                }
                ctx.visit(DSL.power(this.value, DSL.inline(2)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_SQUARE, this.getDataType(), this.value));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Square) {
            return StringUtils.equals(this.value, ((Square)that).value);
        }
        return super.equals(that);
    }
}

