/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.CommonTableExpression;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.TableLike;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class SplitPart
extends AbstractField<String> {
    private final Field<String> string;
    private final Field<String> delimiter;
    private final Field<? extends Number> n;

    SplitPart(Field<String> string, Field<String> delimiter, Field<? extends Number> n) {
        super(Names.N_SPLIT_PART, Tools.allNotNull(SQLDataType.VARCHAR, string, delimiter, n));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.delimiter = Tools.nullSafeNotNull(delimiter, SQLDataType.VARCHAR);
        this.n = Tools.nullSafeNotNull(n, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.substring(DSL.substringIndex(this.string, this.delimiter, this.n), DSL.case_(this.n).when((Field<? extends Number>)DSL.one(), DSL.one()).else_(DSL.length(DSL.substringIndex(this.string, this.delimiter, this.n.minus(DSL.one()))).plus(DSL.length(this.delimiter)).plus(DSL.one()))));
                break;
            }
            case HSQLDB: {
                Field<String> rS = DSL.field(DSL.name("s"), String.class);
                Field<Integer> rN = DSL.field(DSL.name("n"), Integer.TYPE);
                Field<String> rD = DSL.field(DSL.name("d"), String.class);
                Field<Integer> rPos = DSL.position(rS, rD);
                Field<Integer> rLen = DSL.length(rD);
                Field<Integer> rPosN = DSL.nullif(rPos, DSL.zero());
                Field<String> rStr = DSL.substring(rS, rPosN.plus(rLen));
                Field<String> rRes = DSL.coalesce(DSL.substring(rS, DSL.one(), rPosN.minus(DSL.one())), rS);
                CommonTableExpression<Record2<String, String>> s1 = DSL.name("s1").fields("s", "d").as(DSL.select(this.string, this.delimiter));
                CommonTableExpression s2 = DSL.name("s2").fields("s", "d", "x", "n").as(DSL.select(rStr, rD, rRes, DSL.one()).from((TableLike<?>)s1).unionAll((Select)DSL.select(rStr, rD, rRes, rN.plus(DSL.one())).from(DSL.name("s2")).where(rS.isNotNull())));
                Tools.visitSubquery(ctx, DSL.withRecursive(s1, s2).select(DSL.coalesce(DSL.max(DSL.field(DSL.name("x"))), DSL.inline(""))).from((TableLike<?>)s2).where(s2.field("n").eq(this.n)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_SPLIT_PART, this.getDataType(), this.string, this.delimiter, this.n));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof SplitPart) {
            return StringUtils.equals(this.string, ((SplitPart)that).string) && StringUtils.equals(this.delimiter, ((SplitPart)that).delimiter) && StringUtils.equals(this.n, ((SplitPart)that).n);
        }
        return super.equals(that);
    }
}

