/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.SimpleQueryPart;
import org.jooq.impl.Tools;

final class SortFieldImpl<T>
extends AbstractQueryPart
implements SortField<T>,
SimpleQueryPart {
    private static final Set<SQLDialect> NO_SUPPORT_NULLS = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<T> field;
    private final SortOrder order;
    private boolean nullsFirst;
    private boolean nullsLast;

    SortFieldImpl(Field<T> field, SortOrder order) {
        this.field = field;
        this.order = order;
    }

    @Override
    public boolean isSimple() {
        return !this.nullsFirst && !this.nullsLast && Tools.isSimple(this.field);
    }

    @Override
    public final String getName() {
        return this.field.getName();
    }

    @Override
    public final SortOrder getOrder() {
        return this.order;
    }

    final Field<T> getField() {
        return this.field;
    }

    final boolean getNullsFirst() {
        return this.nullsFirst;
    }

    final boolean getNullsLast() {
        return this.nullsLast;
    }

    final <U> SortField<U> transform(Field<U> newField) {
        if (newField == this.field) {
            return this;
        }
        SortField<U> r = newField.sort(this.order);
        return this.nullsFirst ? r.nullsFirst() : (this.nullsLast ? r.nullsLast() : r);
    }

    @Override
    public final SortField<T> nullsFirst() {
        this.nullsFirst = true;
        this.nullsLast = false;
        return this;
    }

    @Override
    public final SortField<T> nullsLast() {
        this.nullsFirst = false;
        this.nullsLast = true;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.nullsFirst || this.nullsLast) {
            if (NO_SUPPORT_NULLS.contains((Object)ctx.dialect())) {
                Param<Integer> ifNull = this.nullsFirst ? DSL.zero() : DSL.one();
                Param<Integer> ifNotNull = this.nullsFirst ? DSL.one() : DSL.zero();
                ctx.visit(DSL.nvl2(this.field, ifNotNull, ifNull)).sql(", ");
                this.acceptFieldAndOrder(ctx, false);
            } else {
                this.acceptFieldAndOrder(ctx, true);
            }
        } else {
            this.acceptFieldAndOrder(ctx, false);
        }
    }

    private final void acceptFieldAndOrder(Context<?> ctx, boolean includeNulls) {
        String separator = "";
        for (Field<T> f : Tools.flatten(this.field)) {
            ctx.sql(separator).visit(f);
            if (this.order != SortOrder.DEFAULT) {
                ctx.sql(' ').visit(this.order.toKeyword());
            }
            if (includeNulls) {
                if (this.nullsFirst) {
                    ctx.sql(' ').visit(Keywords.K_NULLS_FIRST);
                } else {
                    ctx.sql(' ').visit(Keywords.K_NULLS_LAST);
                }
            }
            separator = ", ";
        }
    }
}

