/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.RowId;
import org.jooq.Table;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

final class RowIdField
extends AbstractField<RowId> {
    private final Table<?> table;

    RowIdField(Table<?> table) {
        super(table.getQualifiedName().append(DSL.unquotedName("rowid")), SQLDataType.ROWID);
        this.table = table;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                ctx.visit(this.table.getQualifiedName().append(DSL.unquotedName("_rowid_")));
                break;
            }
            case POSTGRES: {
                ctx.visit(this.table.getQualifiedName().append(DSL.unquotedName("ctid")));
                break;
            }
            default: {
                ctx.visit(this.getQualifiedName());
            }
        }
    }
}

