/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Round<T extends Number>
extends AbstractField<T> {
    private final Field<T> value;
    private final Field<Integer> decimals;

    Round(Field<T> value) {
        super(Names.N_ROUND, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.decimals = null;
    }

    Round(Field<T> value, Field<Integer> decimals) {
        super(Names.N_ROUND, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value, decimals));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.decimals = Tools.nullSafeNotNull(decimals, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                if (this.decimals == null) {
                    ctx.visit(DSL.when(Internal.isub(this.value, DSL.floor(this.value)).lessThan(0.5), DSL.floor(this.value)).otherwise(DSL.ceil(this.value)));
                    return;
                }
                if (this.decimals instanceof Param) {
                    Integer decimalsValue = (Integer)((Param)this.decimals).getValue();
                    Param<BigDecimal> factor = DSL.val(BigDecimal.ONE.movePointRight(decimalsValue));
                    Field<T> mul = Internal.imul(this.value, factor);
                    ctx.visit(DSL.when(Internal.isub(mul, DSL.floor(mul)).lessThan(0.5), Internal.idiv(DSL.floor(mul), factor)).otherwise(Internal.idiv(DSL.ceil(mul), factor)));
                    return;
                }
            }
            case POSTGRES: {
                if (this.decimals == null) {
                    ctx.visit(DSL.function(Names.N_ROUND, this.getDataType(), this.value));
                } else {
                    ctx.visit(DSL.function(Names.N_ROUND, this.getDataType(), Tools.castIfNeeded(this.value, SQLDataType.NUMERIC), this.decimals));
                }
                return;
            }
        }
        if (this.decimals == null) {
            ctx.visit(DSL.function(Names.N_ROUND, this.getDataType(), this.value));
        } else {
            ctx.visit(DSL.function(Names.N_ROUND, this.getDataType(), this.value, this.decimals));
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Round) {
            return StringUtils.equals(this.value, ((Round)that).value) && StringUtils.equals(this.decimals, ((Round)that).decimals);
        }
        return super.equals(that);
    }
}

