/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Repeat
extends AbstractField<String> {
    private final Field<String> string;
    private final Field<? extends Number> count;

    Repeat(Field<String> string, Field<? extends Number> count) {
        super(Names.N_REPEAT, Tools.allNotNull(SQLDataType.VARCHAR, string, count));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.count = Tools.nullSafeNotNull(count, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(DSL.rpad(this.string, Internal.imul(DSL.length(this.string), this.count), this.string));
                break;
            }
            case SQLITE: {
                ctx.visit(Names.N_REPLACE).sql('(').visit(Names.N_HEX).sql('(').visit(Names.N_ZEROBLOB).sql('(').visit(this.count).sql(")), '00', ").visit(this.string).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_REPEAT, this.getDataType(), this.string, this.count));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Repeat) {
            return StringUtils.equals(this.string, ((Repeat)that).string) && StringUtils.equals(this.count, ((Repeat)that).count);
        }
        return super.equals(that);
    }
}

