/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.AbstractWindowFunction;
import org.jooq.impl.DSL;

final class PositionalWindowFunction<T>
extends AbstractWindowFunction<T> {
    private final PositionalFunctionType functionType;
    private final Field<T> arg;
    private final Field<Integer> offset;
    private final Field<T> defaultValue;

    PositionalWindowFunction(PositionalFunctionType functionType, Field<T> arg) {
        this(functionType, arg, null, null);
    }

    PositionalWindowFunction(PositionalFunctionType functionType, Field<T> arg, Field<Integer> offset, Field<T> defaultValue) {
        super(functionType.name, arg.getDataType().null_());
        this.functionType = functionType;
        this.arg = arg;
        this.offset = offset;
        this.defaultValue = defaultValue;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.defaultValue == null) {
            this.accept0(ctx);
        } else {
            switch (ctx.family()) {
                default: 
            }
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(this.functionType.name).sql('(');
        ctx.visit(this.arg);
        if (this.offset != null) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(", ").visit(this.offset);
        }
        if (this.defaultValue != null) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(", ").visit(this.defaultValue);
        }
        ctx.sql(')');
        this.acceptFromFirstOrLast(ctx);
        this.acceptNullTreatment(ctx);
        this.acceptOverClause(ctx);
    }

    final boolean isLeadOrLag() {
        return this.functionType == PositionalFunctionType.LEAD || this.functionType == PositionalFunctionType.LAG;
    }

    static enum PositionalFunctionType {
        LEAD,
        LAG,
        FIRST_VALUE,
        LAST_VALUE,
        NTH_VALUE;

        private final Name name = DSL.unquotedName(this.name().toLowerCase());
    }
}

