/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Position
extends AbstractField<Integer> {
    private final Field<String> in;
    private final Field<String> search;
    private final Field<? extends Number> startIndex;

    Position(Field<String> in, Field<String> search) {
        super(Names.N_POSITION, Tools.allNotNull(SQLDataType.INTEGER, in, search));
        this.in = Tools.nullSafeNotNull(in, SQLDataType.VARCHAR);
        this.search = Tools.nullSafeNotNull(search, SQLDataType.VARCHAR);
        this.startIndex = null;
    }

    Position(Field<String> in, Field<String> search, Field<? extends Number> startIndex) {
        super(Names.N_POSITION, Tools.allNotNull(SQLDataType.INTEGER, in, search, startIndex));
        this.in = Tools.nullSafeNotNull(in, SQLDataType.VARCHAR);
        this.search = Tools.nullSafeNotNull(search, SQLDataType.VARCHAR);
        this.startIndex = Tools.nullSafeNotNull(startIndex, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.startIndex != null) {
            switch (ctx.family()) {
                case DERBY: 
                case H2: {
                    ctx.visit(Names.N_LOCATE).sql('(').visit(this.search).sql(", ").visit(this.in).sql(", ").visit(this.startIndex).sql(')');
                    break;
                }
                default: {
                    ctx.visit(DSL.case_(DSL.position(DSL.substring(this.in, this.startIndex), this.search)).when((Field<Integer>)DSL.inline(0), DSL.inline(0)).else_(Internal.iadd(DSL.position(DSL.substring(this.in, this.startIndex), this.search), Internal.isub(this.startIndex, DSL.one()))));
                    break;
                }
            }
        } else {
            switch (ctx.family()) {
                case DERBY: {
                    ctx.visit(Names.N_LOCATE).sql('(').visit(this.search).sql(", ").visit(this.in).sql(')');
                    break;
                }
                case SQLITE: {
                    ctx.visit(Names.N_INSTR).sql('(').visit(this.in).sql(", ").visit(this.search).sql(')');
                    break;
                }
                default: {
                    ctx.visit(Names.N_POSITION).sql('(').visit(this.search).sql(' ').visit(Keywords.K_IN).sql(' ').visit(this.in).sql(')');
                }
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Position) {
            return StringUtils.equals(this.in, ((Position)that).in) && StringUtils.equals(this.search, ((Position)that).search) && StringUtils.equals(this.startIndex, ((Position)that).startIndex);
        }
        return super.equals(that);
    }
}

