/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Overlay
extends AbstractField<String> {
    private final Field<String> in;
    private final Field<String> placing;
    private final Field<? extends Number> startIndex;
    private final Field<? extends Number> length;
    private static final Set<SQLDialect> NO_SUPPORT = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_INSERT = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL);

    Overlay(Field<String> in, Field<String> placing, Field<? extends Number> startIndex) {
        super(Names.N_OVERLAY, Tools.allNotNull(SQLDataType.VARCHAR, in, placing, startIndex));
        this.in = Tools.nullSafeNotNull(in, SQLDataType.VARCHAR);
        this.placing = Tools.nullSafeNotNull(placing, SQLDataType.VARCHAR);
        this.startIndex = Tools.nullSafeNotNull(startIndex, SQLDataType.INTEGER);
        this.length = null;
    }

    Overlay(Field<String> in, Field<String> placing, Field<? extends Number> startIndex, Field<? extends Number> length) {
        super(Names.N_OVERLAY, Tools.allNotNull(SQLDataType.VARCHAR, in, placing, startIndex, length));
        this.in = Tools.nullSafeNotNull(in, SQLDataType.VARCHAR);
        this.placing = Tools.nullSafeNotNull(placing, SQLDataType.VARCHAR);
        this.startIndex = Tools.nullSafeNotNull(startIndex, SQLDataType.INTEGER);
        this.length = Tools.nullSafeNotNull(length, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        Field<? extends Number> l = this.length;
        if (l != null) {
            if (SUPPORT_INSERT.contains((Object)ctx.dialect())) {
                ctx.visit(DSL.function(Names.N_INSERT, this.getDataType(), this.in, this.startIndex, l, this.placing));
            } else if (NO_SUPPORT.contains((Object)ctx.dialect())) {
                ctx.visit(DSL.substring(this.in, DSL.inline(1), Internal.isub(this.startIndex, DSL.inline(1))).concat(this.placing).concat(DSL.substring(this.in, Internal.iadd(this.startIndex, l))));
            } else {
                ctx.visit(Names.N_OVERLAY).sql('(').visit(this.in).sql(' ').visit(Keywords.K_PLACING).sql(' ').visit(this.placing).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.startIndex).sql(' ').visit(Keywords.K_FOR).sql(' ').visit(l).sql(')');
            }
        } else if (SUPPORT_INSERT.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.function(Names.N_INSERT, this.getDataType(), this.in, this.startIndex, DSL.length(this.placing), this.placing));
        } else if (NO_SUPPORT.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.substring(this.in, DSL.inline(1), Internal.isub(this.startIndex, DSL.inline(1))).concat(this.placing).concat(DSL.substring(this.in, Internal.iadd(this.startIndex, DSL.length(this.placing)))));
        } else {
            ctx.visit(Names.N_OVERLAY).sql('(').visit(this.in).sql(' ').visit(Keywords.K_PLACING).sql(' ').visit(this.placing).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.startIndex).sql(')');
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Overlay) {
            return StringUtils.equals(this.in, ((Overlay)that).in) && StringUtils.equals(this.placing, ((Overlay)that).placing) && StringUtils.equals(this.startIndex, ((Overlay)that).startIndex) && StringUtils.equals(this.length, ((Overlay)that).length);
        }
        return super.equals(that);
    }
}

