/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class NotField
extends AbstractField<Boolean> {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT};
    private final Field<Boolean> field;

    NotField(Field<Boolean> field) {
        super(Names.N_NOT, SQLDataType.BOOLEAN);
        this.field = field;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case FIREBIRD: {
                ctx.visit(DSL.field(DSL.not(DSL.condition(this.field))));
                break;
            }
            default: {
                ctx.visit(Keywords.K_NOT).sql('(').visit(Tools.hasDefaultConverter(this.field) ? this.field : DSL.condition(this.field)).sql(')');
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

